<?php
ini_set('session.gc_maxlifetime', 30 * 60 * 60 * 60);
session_start();
$_SESSION["brand"] = "";
if ($_SESSION["CURRENT_USER"] == "") {
    exit("Please Login");
}
require_once("connectioni.php"); // Ensure DB connection is available
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stock Gin Transfer</title>
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <!-- Scripts -->
    <script type="text/javascript" src="js/jquery-3.5.1.js"></script>
    <script type="text/javascript" src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
    
    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles */
        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c;
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }
        
        /* Box/Card Styling */
        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
        }
        .box-primary { border-top-color: #3c8dbc; }
        .box-success { border-top-color: #00a65a; }
        .box-warning { border-top-color: #f39c12; }
        
        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
            background-color: #f9fafc;
        }
        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
            font-weight: 600;
        }
        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }
        .form-control[disabled], .form-control[readonly], fieldset[disabled] .form-control {
            background-color: #eee;
        }

        /* Buttons */
        .btn {
            border-radius: 3px;
            box-shadow: none;
            border: 1px solid transparent;
        }
        .btn-app {
            border-radius: 3px;
            position: relative;
            padding: 15px 5px;
            margin: 0 0 10px 10px;
            min-width: 80px;
            height: 60px;
            text-align: center;
            color: #666;
            border: 1px solid #ddd;
            background-color: #f4f4f4;
            font-size: 12px;
        }
        .btn-app > .fa, .btn-app > .glyphicon, .btn-app > .ion {
            font-size: 20px;
            display: block;
            margin-bottom: 10px;
        }
        .btn-app:hover {
            background: #f4f4f4;
            color: #444;
            border-color: #aaa;
        }
        
         /* Modals */
        .modal-body {
            background-color: #fff;
        }
        
        .table-responsive {
            overflow-x: auto;
        }

        /* Table Styling */
         th {
            background-color: #f4f4f4;
            font-weight: bold;
        }
        
         .alert-warning {
             color: #8a6d3b;
            background-color: #fcf8e3;
            border-color: #faebcc;
            padding: 10px;
            margin-bottom: 10px;
            border: 1px solid transparent;
            border-radius: 4px;
         }
         .alert-success {
            color: #3c763d;
            background-color: #dff0d8;
            border-color: #d6e9c6;
             padding: 10px;
            margin-bottom: 10px;
            border: 1px solid transparent;
            border-radius: 4px;
         }
         
         .center-block {
             text-align: center;
             display: block;
         }

    </style>
     <script type="text/javascript">
        // Window Popup Helper
        function NewWindow(mypage,myname,w,h,scroll,pos){
            if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
            if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
            else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
            settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
            win=window.open(mypage,myname,settings);
        }
    </script>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        
        <div class="page-title-box">
            Stock Gin Transfer
        </div>
        
        <div class="user-info">
             <span>Welcome, <span class="user-name"><?php echo $_SESSION['user_name']; ?></span> [<?php echo $_SESSION['company']; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

<div class="content-wrapper">
    <section class="content">

        <!-- Action Toolbar -->
        <div class="box box-solid">
            <div class="box-body">
                <a onclick="new_inv();" class="btn btn-app">
                    <i class="fa fa-user-plus"></i> New
                </a>
                
                <?php 
                // DB Connection is assumed via connectioni.php or inherited globals
                // Using $GLOBALS['dbinv'] for consistency if present, or $conn from connectioni.php
                // The original code used $conn for permissions
                 
                $sql_userp="select * from view_userpermission where username='".$_SESSION["UserName"]."' and docname='STOCK GIN TRANSFER' and grp='Data Capture' ";
                // Assuming $conn is available from connectioni.php, if not fallback to global
                if(isset($conn)){
                     $result_userp = $conn->query($sql_userp);
                     $row_userp = $result_userp->fetch();
                } else if (isset($GLOBALS['dbinv'])) {
                     $result_userp = mysqli_query($GLOBALS['dbinv'], $sql_userp);
                     $row_userp = mysqli_fetch_array($result_userp);
                }

                if (isset($row_userp)) {
            	    if($row_userp['doc_feed']==1){
            	       echo" <a onclick='save_inv();' class='btn btn-app'>
                            <i class='fa fa-save'></i> Save
                        </a> ";
            	    } 
            	    if($row_userp['doc_view']==1){
            	       echo" <a onclick=\"NewWindow('stock_gin_transfer_search.php', 'mywin', '800', '700', 'yes', 'center'); return false\" class='btn btn-app'>
                            <i class='fa fa-search'></i> Search
                        </a> ";
            	    } 
            	     if($row_userp['doc_print']==1){
            	       echo" <a onclick='print_inv();' class='btn btn-app'>
                            <i class='fa fa-print'></i> Print
                        </a> ";
            	    }
            	    if($row_userp['doc_cancel']==1){
            	       echo" <a onclick='cancel_inv();' class='btn btn-app'>
                            <i class='fa fa-trash'></i> Cancel
                        </a> ";
            	    }
                }
            	?>	
            </div>
        </div>
        
        <!-- System Messages -->
        <div id="msg_box"></div>

        <form role="form" name="form1" id="form1">
            <input type="hidden" disabled id="tmpno" class="form-control">
            <input type="hidden" id="item_count" class="form-control">

            <!-- Main Form -->
            <div class="row">
                 <div class="col-md-12">
                     <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Details</h3>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Ref No</label>
                                        <input type="text" placeholder="Ref No" disabled id="invno" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Date</label>
                                        <input type="date" disabled id="sdate" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                     <div class="form-group">
                                        <label>To Department</label>
                                         <select id="to_dep" class="form-control">
                                            <?php
                                            $sql = "select * from s_stomas where act='1' order by CODE";
                                            $result = mysqli_query($GLOBALS['dbinv'], $sql);
                                            while ($row = mysqli_fetch_array($result)) {
                                                if ($row["CODE"] == "01") {
                                                    echo "<option selected value='" . $row["CODE"] . "'>" . $row["DESCRIPTION"] . "</option>";
                                                } else {
                                                    echo "<option value='" . $row["CODE"] . "'>" . $row["DESCRIPTION"] . "</option>";
                                                }
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <label>Above 90 Days Qty</label>
                                    <div id="unsold"></div>
                                </div>
                            </div>
                        </div>
                     </div>
                 </div>
            </div>

            <!-- Item Details -->
            <div class="row">
                <div class="col-md-12">
                     <div class="box box-default">
                          <div class="box-header with-border">
                            <h3 class="box-title">Item List</h3>
                        </div>
                        <div class="box-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th style="width: 20%;">From Department</th>
                                            <th style="width: 15%;">Item Code</th>
                                            <th style="width: 5%;"></th>
                                            <th style="width: 30%;">Description</th>
                                            <th style="width: 15%;">Rate</th>
                                            <th style="width: 10%;">Quantity</th>
                                            <th style="width: 5%;"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <select id="from_dep" onblur="itno_ind();" class="form-control">
                                                <?php
                                                 if (isset($_SESSION["CURRENT_DEP"]) && $_SESSION["CURRENT_DEP"] != "") {
                                                   $sql="select * from s_stomas where  act='1' and CODE='".$_SESSION["CURRENT_DEP"] ."' order by CODE";
                                                }else{
                                                  $sql="select * from s_stomas where  act='1'  order by CODE";
                                                } 
                         
                                                $result = mysqli_query($GLOBALS['dbinv'], $sql);
                                                while ($row = mysqli_fetch_array($result)) {
                                                    if ($row["CODE"] == "01") {
                                                        echo "<option selected value='" . $row["CODE"] . "'>" . $row["DESCRIPTION"] . "</option>";
                                                    } else {
                                                        echo "<option value='" . $row["CODE"] . "'>" . $row["DESCRIPTION"] . "</option>";
                                                    }
                                                }
                                                ?>
                                                </select>
                                            </td>
                                            <td>
                                                 <input type="text" onkeypress="keyset('qty', event);" onblur="itno_ind();" disabled placeholder="Item Code" id="itemCode" class="form-control">
                                            </td>
                                            <td>
                                                 <button type="button" class="btn btn-primary" onclick="search_item();"><i class="fa fa-search"></i></button>
                                            </td>
                                            <td>
                                                <input type="text" placeholder="Description" id="itemDesc" disabled class="form-control">
                                            </td>
                                             <td>
                                                <input type="number" onkeypress="keyset('add_tmp_it', event);" placeholder="Rate" id="rate" class="form-control">
                                            </td>
                                            <td>
                                                 <input type="number" placeholder="Quantity" id="qty" class="form-control">
                                            </td>
                                            <td>
                                                <a onclick="add_tmp();" id="add_tmp_it" class="btn btn-primary"><i class="fa fa-plus"></i></a>
                                                <input id="itemPrice" type="hidden">
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12">
                                     <div id="submas"></div>
                                </div>
                            </div>
                            
                            <!-- Dynamic Item Table -->
                             <div class="row">
                                <div class="col-md-12">
                                     <div id="itemdetails"></div>
                                </div>
                            </div>
                        </div>
                     </div>
                </div>
            </div>
            
            <!-- Footer -->
             <div class="row">
                 <div class="col-md-12">
                      <div class="box box-default">
                           <div class="box-body">
                               <div class="row">
                                   <div class="col-md-2">
                                       <div class="form-group">
                                           <label>Available Qty</label>
                                           <input type="text" disabled style="color: red; font-weight:bold;" name='qtyinhand' id="qtyinhand" class="form-control">
                                       </div>
                                   </div>
                                    <div class="col-md-2">
                                       <div class="form-group">
                                           <label>ARN No</label>
                                           <input type="text" name="txtarno" id="txtarno" disabled class="form-control">
                                       </div>
                                   </div>
                                    <div class="col-md-3">
                                       <div class="form-group">
                                           <label>&nbsp;</label><br>
                                            <button type="button" class="btn btn-primary" onclick="NewWindow('serach_arn.php?mstatus=gin', 'mywin', '800', '700', 'yes', 'center'); return false;">
                                                <i class="fa fa-search"></i>
                                            </button>
                                            <button type="button" class="btn btn-success" onclick="update();">
                                                <i class="fa fa-edit"></i> Update ARN
                                            </button>
                                       </div>
                                   </div>
                                   <div class="col-md-2">
                                        <div class="form-group">
                                            <label>ARN Date</label>
                                            <input type="text" disabled class="form-control" name="DTARdate" id="DTARdate"/>
                                        </div>
                                   </div>
                                   <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Total Amount</label>
                                            <input type="text" name="totamount" id="totamount" disabled class="form-control" style="font-weight: bold; font-size: 16px;"> 
                                        </div>
                                   </div>
                               </div>
                           </div>
                      </div>
                 </div>
             </div>

        </form>

    </section>
</div>

<?php
include 'stock_gin_transfer_item_search.php';
?>

<script src="js/stock_gin_transfer.js"></script>
<script>
    new_inv();
    
    // Keyboard Shortcut for Logout (Ctrl+Q)
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
            event.preventDefault();
            window.location.href = 'logout.php';
        }
    });
</script>
</body>
</html>
