<?php
session_start();
require_once("connection_sql.php");
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_POST['Command']) ? $_POST['Command'] : (isset($_GET['Command']) ? $_GET['Command'] : '');

if ($command == "get_initial_data") {
    $data = [];

    // Departments / Cost Centers
    $sql = "select * from s_stomas order by CODE";
    $res = $conn->query($sql);
    $costcenters = [];
    foreach ($res as $row) {
        $costcenters[] = ['code' => $row['CODE'], 'name' => $row['DESCRIPTION']];
    }
    $data['costcenters'] = $costcenters;

    // Sales Reps
    $sql = "select * from s_salrep where cancel='0' order by REPCODE";
    $res = $conn->query($sql);
    $reps = [];
    foreach ($res as $row) {
        $reps[] = ['code' => $row['REPCODE'], 'name' => $row['Name']];
    }
    $data['reps'] = $reps;

    // Accounts
    $sql = "select * from a_lcodes where CAT='B' OR C_CODE IN ('12501','12503','12101') order by C_CODE";
    $res = $conn->query($sql);
    $accounts = [];
    foreach ($res as $row) {
        $accounts[] = ['code' => $row['C_CODE'], 'name' => $row['C_NAME']];
    }
    $data['accounts'] = $accounts;

    echo json_encode(['status' => 'success', 'data' => $data]);
    exit;
}

if ($command == "new_rec") {
    // Generate RTC No
    $refno = "RTC/" . date("ym") . "/" . rand(1000, 9999);

    echo json_encode([
        'status' => 'success',
        'recno' => $refno,
        'date' => date('Y-m-d')
    ]);
    exit;
}

if ($command == "get_returned_cheques") {
    $cuscode = $_GET['cuscode'];

    // Fetch Returned Cheques capable of being settled
    // Assuming 'cheque_returned' flag or ret_ch_settle logic involves s_invcheq
    // Logic: Select cheques where ret_chno!='' (returned) AND balance > 0?
    // Or maybe just fetch all from s_invcheq where CR_C_CODE = cuscode and RET_FLG = 1?
    // Let's use a standard query assuming `ret_flg` or similar. 
    // Based on legacy `ret_chq_settle.php` it doesn't show the query.
    // However, usually we look for `s_invcheq` where `ret_flg=1` and `cheque_amt > paid`.

    // Simplified query for now:
    $sql = "SELECT * FROM s_invcheq WHERE C_CODE='$cuscode' AND CR_FLG='1' AND (CHEQUE_AMT - PA_AMT) > 0";
    // CR_FLG often used for Cheque Return Flag in some systems, or RET_FLG.
    // If not sure, we will select * from s_invcheq where C_CODE...

    // Let's try to match standard table columns
    $sql = "SELECT * FROM s_invcheq WHERE C_CODE='$cuscode' AND ret_flg='1' AND (CHEQUE_AMT - ifnull(PA_AMT,0)) > 0 ORDER BY CH_DATE";

    // Note: If table columns differ, we might fail. But this is best guess modernization.
    // Safe fallback: just select where C_CODE matches and ret_flg=1.

    try {
        $res = $conn->query($sql);
        $cheques = [];
        foreach ($res as $row) {
            $bal = $row['CHEQUE_AMT'] - ($row['PA_AMT'] ?? 0);
            $cheques[] = [
                'refno' => $row['REF_NO'],
                'cheque_no' => $row['CHNO'],
                'date' => $row['CH_DATE'],
                'amount' => $row['CHEQUE_AMT'],
                'paid' => $row['PA_AMT'] ?? 0,
                'balance' => $bal,
                'id' => $row['ID'] // unique id if available
            ];
        }
        echo json_encode(['status' => 'success', 'cheques' => $cheques]);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }

    exit;
}

if ($command == "save_settlement") {
    try {
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $conn->beginTransaction();

        $input = json_decode(file_get_contents('php://input'), true);

        $recno = $input['recno'];
        $date = $input['date'];
        $cuscode = $input['cuscode'];
        $amount = $input['amount']; // Total Settled
        $payType = $input['payType'];

        $allocations = $input['allocations'] ?? []; // Returned Cheques settled
        $newPayments = $input['newPayments'] ?? []; // New Cash/Cheques given

        // 1. Insert Header into s_crec (Settlement Record)
        // FLAG='RET' for Return Settlement
        $sqlHead = "INSERT INTO s_crec (CA_REFNO, CA_DATE, CA_CODE, CA_AMOUNT, FLAG, DEPARTMENT, TYPE) VALUES (?, ?, ?, ?, 'RET', ?, ?)";
        $dept = $_SESSION['CURRENT_DEP'] ?? '0';

        $stmtHead = $conn->prepare($sqlHead);
        $stmtHead->execute([$recno, $date, $cuscode, $amount, $dept, $payType]);

        // 2. Insert New Payments (e.g. Cash received to settle the return cheque)
        // If Cash:
        $cashAmt = $input['cashTotal'];
        if ($cashAmt > 0) {
            // Insert cash record ... maybe into s_sttr or s_invcheq as cash?
            $stmtHead = $conn->prepare("INSERT INTO s_sttr (ST_REFNO, ST_DATE, ST_INVNO, ST_PAID, ST_FLAG) VALUES (?, ?, 'CASH', ?, 'SET')");
            $stmtHead->execute([$recno, $date, $cashAmt]);
        }

        // If New Cheques:
        $sqlCheq = "INSERT INTO s_invcheq (REF_NO, SDATE, C_CODE, CHNO, CH_DATE, BANK, CHEQUE_AMT, TYPE) VALUES (?, ?, ?, ?, ?, ?, ?, 'REC')";
        $stmtCheq = $conn->prepare($sqlCheq);

        foreach ($newPayments as $pay) {
            if ($pay['type'] == 'Cheque') {
                $stmtCheq->execute([
                    $recno,
                    $date,
                    $cuscode,
                    $pay['no'],
                    $pay['date'],
                    $pay['bank'],
                    $pay['amount']
                ]);
            }
        }

        // 3. Update Settled Returned Cheques
        // Increase PA_AMT on the original returned cheque
        //$sqlUpdate = "UPDATE s_invcheq SET PA_AMT = ifnull(PA_AMT,0) + ? WHERE CHNO = ? AND C_CODE = ?";
        // Better to use ID or RefNo if possible.
        // We will use Cheque No + Ref No.
        $sqlUpdate = "UPDATE s_invcheq SET PA_AMT = ifnull(PA_AMT,0) + ? WHERE REF_NO = ? AND CHNO = ?";
        $stmtUpdate = $conn->prepare($sqlUpdate);

        foreach ($allocations as $alloc) {
            if ($alloc['settle_amount'] > 0) {
                $stmtUpdate->execute([$alloc['settle_amount'], $alloc['refno'], $alloc['cheque_no']]);

                // Record Settlement Log
                $conn->prepare("INSERT INTO s_sttr (ST_REFNO, ST_DATE, ST_INVNO, ST_PAID, ST_CHNO) VALUES (?, ?, ?, ?, ?)")
                    ->execute([$recno, $date, $alloc['refno'], $alloc['settle_amount'], $alloc['cheque_no']]);
            }
        }

        $conn->commit();
        echo json_encode(['status' => 'success', 'message' => 'Saved Successfully', 'recno' => $recno]);

    } catch (Exception $e) {
        $conn->rollBack();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}
?>