<?php
session_start();
require_once("connection_sql.php");
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_POST['Command']) ? $_POST['Command'] : (isset($_GET['Command']) ? $_GET['Command'] : '');

if ($command == "get_list") {
    try {
        // Logic: reject='1' and cancel='0' and invno is null
        $sql = "select * from dag_item WHERE reject='1' and cancel='0' and invno is null";

        // Filter by company if needed
        // if(isset($_SESSION['company']) && $_SESSION['company'] != "" && $_SESSION['company'] != "ALL") {
        //     $sql .= " and company='".$_SESSION['company']."'";
        // }

        $sql .= " ORDER BY id DESC";

        $result = $conn->query($sql);

        $data = [];
        $i = 1;

        foreach ($result as $row) {

            // History Count Logic
            $sql1 = "Select count(*) as count from dag_item  where cancel='0'  and  serialno='" . $row['serialno'] . "' group by  serialno asc";
            $result_1 = $conn->query($sql1);
            $row_1 = $result_1->fetch();
            $history_count = $row_1['count'] ?? 0;

            $data[] = [
                'id' => $row['id'],
                'jobno' => $row['jobno'],
                'refno' => $row['refno'],
                'sdate' => $row['sdate'],
                'cusname' => $row['cusname'],
                'marker' => $row['marker'],
                'size' => $row['size'],
                'serialno' => $row['serialno'],
                'amount' => $row['amount'],
                'repair' => $row['repair'],
                'total' => $row['total'],
                'onhand_date' => $row['onhand_date'], // Send Date
                'pro_date' => $row['pro_date'], // Finish Date
                'remark' => $row['remark'],
                'history_count' => $history_count
            ];
            $i++;
        }

        echo json_encode(['status' => 'success', 'data' => $data]);

    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "revert_production") {
    try {
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $conn->beginTransaction();

        $refno = $_POST['refno'] ?? '';
        $serialno = $_POST['serialno'] ?? '';

        // Revert: reject='0', flag='1' (Back to Production)
        $sql = "UPDATE dag_item set reject='0', flag='1' where refno='" . $refno . "' and serialno='" . $serialno . "' and cancel='0'";
        $conn->query($sql);

        $sqllog = "insert into entry_log(refno, username, docname, trnType, stime, sdate) values ('" . trim($refno) . "', '" . $_SESSION["CURRENT_USER"] . "', 'REVERT REJECT TO PRODUCTION', 'Update', '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d") . "')";
        $conn->query($sqllog);

        $conn->commit();
        echo json_encode(['status' => 'success', 'message' => 'REVERTED TO PRODUCTION']);

    } catch (Exception $e) {
        $conn->rollBack();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}
?>