<?php 
session_start();
require_once("connectioni.php");
$_SESSION["save_sales_inv"]=0;
$_SESSION["brand"]="";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quotation</title>
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <!-- Main Logic -->
    <script language="javascript" src="js/quotation.js"></script>

    <!-- Popup Window Script -->
    <script language="javascript" type="text/javascript">
    var win=null;
    function NewWindow(mypage,myname,w,h,scroll,pos){
        if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
        if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
        else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
        settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
        win=window.open(mypage,myname,settings);
    }
    </script>
    
    <!-- Initial Load Script -->
    <script type="text/javascript">
     window.onload = function(){
        new_inv(); // Initialize
     };
    </script>

    <style>
        body {
            background-color: #ecf0f5; /* Light grey background for ERP feel */
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles from pos_inv.php */
        .navbar-custom {
            background-color: #2c3e50; /* Primary Color */
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c; /* Danger Color */
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }
        
        /* Box/Card Styling */
        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
        }
        .box.box-primary {
            border-top-color: #3c8dbc;
        }
        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
        }
        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
        }
        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }
        .control-label {
            font-weight: 600;
            text-align: left !important; /* ERP convention */
            padding-top: 7px;
        }
        
        /* Buttons */
        .btn {
            border-radius: 3px;
            box-shadow: none;
            border: 1px solid transparent;
        }

        /* Table Styling Overrides (for AJAX Content) */
        #itemdetails table {
            width: 100%;
            margin-bottom: 20px;
            border: 1px solid #f4f4f4;
            border-collapse: collapse;
            font-size: 13px;
        }
        #itemdetails table th, #itemdetails table td {
            padding: 8px;
            line-height: 1.42857143;
            vertical-align: top;
            border: 1px solid #ddd;
        }
        #itemdetails table tr:first-child td {
            background-color: #3c8dbc !important;
            color: white !important;
            font-weight: bold;
            border-bottom: 2px solid #3c8dbc;
        }

        /* Utility */
        .mt-10 { margin-top: 10px; }
        .mb-10 { margin-bottom: 10px; }
        .p-0 { padding: 0 !important; }
        
        /* Specific overrides for legacy behavior */
        .hidden { display: none; }
        input[disabled], select[disabled], textarea[disabled] {
            cursor: not-allowed;
            background-color: #eee;
            opacity: 1;
        }
    </style>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        
        <div class="page-title-box">
            Quotation
        </div>
        
        <div class="user-info">
            <span>Welcome, <span class="user-name"><?php echo $_SESSION['user_name']; ?></span> [<?php echo $_SESSION['company']; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

<div class="content-wrapper">
    <section class="content">

        <!-- Action Toolbar -->
        <div class="box box-solid">
            <div class="box-body">
                <a onclick="new_inv();" class="btn btn-app">
                    <i class="fa fa-plus"></i> New
                </a>
                <a onclick="save_inv();" class="btn btn-app">
                    <i class="fa fa-save"></i> Save
                </a>
                <a onclick="cancel_inv();" class="btn btn-app">
                    <i class="fa fa-ban"></i> Cancel
                </a>
                <a onclick="print_inv();" class="btn btn-app">
                    <i class="fa fa-print"></i> Print
                </a>
                <a onclick="close_form();" class="btn btn-app">
                    <i class="fa fa-close"></i> Close
                </a>
                
                <div class="pull-right" style="margin-top: 15px;">
                     <div class="btn-group" data-toggle="buttons">
                        <label class="btn btn-default active">
                            <input type="radio" name="paymethod" value="credit" id="paymethod_0" autocomplete="off" checked> Credit
                        </label>
                        <label class="btn btn-default">
                            <input type="radio" name="paymethod" value="cash" id="paymethod_1" autocomplete="off"> Cash
                        </label>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Left Column: Primary Details -->
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Quotation Details</h3>
                    </div>
                    <div class="box-body">
                        <form role="form" name="form1" id="form1" class="form-horizontal">
                            
                            <!-- Row 1: Order No & Date -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Sales Order No</label>
                                <div class="col-sm-2">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="salesord1" id="salesord1" disabled onkeypress="keyset('searchcust',event);" onfocus="got_focus('invno');" onblur="lost_focus('invno');">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" onclick="NewWindow('serach_ord.php?stname=inv_mast','mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-1 control-label">Date</label>
                                <div class="col-sm-2">
                                    <input type="date" class="form-control input-sm" name="invdate" id="invdate" value="<?php echo date("Y-m-d"); ?>">
                                </div>
                            </div>

                            <!-- Row 2: Quotation No & Customer -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Quotation No</label>
                                <div class="col-sm-2">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="invno" id="invno" disabled>
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="search_quot.php?stname=quot" onclick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                
                                <label class="col-sm-1 control-label">Customer</label>
                                <div class="col-sm-1">
                                     <input type="text" class="form-control input-sm" name="firstname_hidden" id="firstname_hidden" disabled onblur="custno_ind('')" onkeypress="keyset('department',event);">
                                </div>
                                <div class="col-sm-2">
                                     <div class="input-group">
                                         <input type="text" class="form-control input-sm" name="firstname" id="firstname" disabled>
                                         <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" onclick="NewWindow('serach_customer.php?stname=quot','mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                         </span>
                                     </div>
                                </div>
                            </div>

                            <!-- Row 3: Address & Credit Limit -->
                             <div class="form-group">
                                <label class="col-sm-1 control-label">Address</label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="cus_address" id="cus_address">
                                </div>
                                
                                <label class="col-sm-1 control-label">Credit Limit</label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="creditlimit" id="creditlimit" value="0" disabled onkeypress="keyset('balance',event);">
                                </div>
                            </div>
                            
                            <!-- Row 4: Balance & Department -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Department</label>
                                <div class="col-sm-2">
                                    <select name="department" id="department" class="form-control input-sm" onkeypress="keyset('brand',event);" onchange="setord();">
                                        <?php
                                        if ( $_SESSION["CURRENT_DEP"] != "" ) {
                                            $sql = "select * from s_stomas where act ='1' and CODE='" . $_SESSION["CURRENT_DEP"] . "'  order by CODE";
                                        } else {
                                            $sql = "select * from s_stomas where act='1' order by CODE";
                                        }
                                        $result = mysqli_query($GLOBALS['dbinv'], $sql);
                                        while ($row = mysqli_fetch_array($result)) {
                                            if ($row["CODE"] == "01") {
                                                echo "<option selected value='" . $row["CODE"] . "'>" . $row["DESCRIPTION"] . "-" . $row["CODE"] . "</option>";
                                            } else {
                                                echo "<option value='" . $row["CODE"] . "'>" . $row["DESCRIPTION"] . "-" . $row["CODE"] . "</option>";
                                            }
                                        }
                                        ?>
                                    </select>
                                </div>
                                <label class="col-sm-1 control-label">Balance</label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="balance" id="balance" value="0" disabled onkeypress="keyset('department',event);">
                                </div>
                            </div>

                            <!-- Row 5: VAT & Marketing Executive -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">VAT No</label>
                                <div class="col-sm-2">
                                    <div class="row">
                                        <div class="col-xs-6">
                                            <input type="text" class="form-control input-sm" name="vat1" id="vat1" placeholder="VAT 1" onkeypress="keyset('vat2',event);">
                                        </div>
                                        <div class="col-xs-6">
                                            <input type="text" class="form-control input-sm" name="vat2" id="vat2" placeholder="VAT 2" onkeypress="keyset('salesrep',event);">
                                        </div>
                                    </div>
                                </div>
                                
                                <label class="col-sm-1 control-label">Executive</label>
                                <div class="col-sm-2">
                                     <select name="salesrep" id="salesrep" class="form-control input-sm" onkeypress="keyset('dte_dor',event);" onchange="setord();">
                                      <?php
                                      if ($_SESSION["MANAGER"] != "") {
                                        $sql = "select * from s_salrep where pactive='1' and manager='" . $_SESSION["MANAGER"] . "'order by REPCODE";
                                      } else if ($_SESSION["CURRENT_REP"] == "") {
                                        $sql = "select * from s_salrep where pactive='1' order by REPCODE";
                                      } else {
                                        $sql = "select * from s_salrep where pactive='1' and repcode = '" . $_SESSION["CURRENT_REP"] . "' order by REPCODE";
                                      }
                                      $result = mysqli_query($GLOBALS['dbinv'], $sql);
                                      while ($row = mysqli_fetch_array($result)) {
                                        echo "<option value='" . $row["REPCODE"] . "'>" . $row["REPCODE"] . " " . $row["Name"] . "</option>";
                                      }
                                      ?>
                                    </select>
                                </div>
                            </div>

                             <!-- Row 6: VAT Type -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Invoice Type</label>
                                <div class="col-sm-4">
                                    <label class="radio-inline"><input type="radio" name="vatgroup" value="vat" id="vatgroup_0"> VAT Invoice</label>
                                    <label class="radio-inline"><input type="radio" name="vatgroup" value="non" id="vatgroup_1"> Non VAT Invoice</label>
                                    <label class="radio-inline"><input type="radio" name="vatgroup" value="svat" id="vatgroup_2"> SVAT Invoice</label>
                                    <label class="radio-inline"><input type="radio" name="vatgroup" value="evat" id="vatgroup_3"> EVAT Invoice</label>
                                </div>
                            </div>
                            
                            <!-- Row 7: Remarks -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Remark</label>
                                <div class="col-sm-4">
                                    <textarea name="TXTREMARK" id="TXTREMARK" class="form-control" rows="2"></textarea>
                                </div>
                            </div>
                            
                            <!-- Hidden Fields -->
                            <div class="hidden">
                                <input id="dte_dor" name="dte_dor" type="hidden" />
                                <select name="brand" id="brand">
                                    <?php
                                        if (($_SESSION["CURRENT_DEP"] != "") and (!is_numeric($_SESSION["CURRENT_DEP"]))) {
                                            $sql="select * from brand_mas where act ='1' and costcenter='".$_SESSION["CURRENT_DEP"]."' order by barnd_name"; 
                                        }else{
                                            $sql="select * from brand_mas where act ='1' order by barnd_name";
                                        } 
                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                        while($row = mysqli_fetch_array($result)){
                                            echo "<option value='".$row["barnd_name"]."'>".$row["barnd_name"]."</option>";
                                        }
                                    ?>
                                </select>
                                <select name="COM_GROUPS" id="COM_GROUPS">
                                     <option value=""></option>
                                     <option value="TYRES">TYRES</option>
                                     <option value="BATTERIES">BATTERIES</option>
                                     <option value="TUBES">TUBES</option>
                                </select>
                                <input type="hidden" name="item_count" id="item_count" value="0" />
                                <!-- Legacy hidden fields from original details -->
                                <input type="checkbox" name="Check1" id="Check1" />
                                <input type="text" name="Combo1" id="Combo1">
                                <input type="checkbox" name="Check2" id="Check2" />
                                <input type="checkbox" name="Check6" id="Check6" />
                                <input type="checkbox" name="Check7" id="Check7" />
                                <select name="Combo11" id="Combo11"></select> 
                                <input type="text" name="txt_country" id="txt_country" />
                                <input type="text" name="txt_milage" id="txt_milage" />
                                <input type="text" name="stklevel" id="stklevel" />
                            </div>

                            <hr>
                            <h4 class="box-title text-primary">Item Details</h4>
                            
                            <!-- Add New Item Row -->
                            <div class="row bg-info" style="padding: 10px; margin: 0; border-radius: 3px;">
                                <div class="col-md-2 p-0">
                                    <label>Code</label>
                                    <input type="text" class="form-control input-sm" name="itemd_hidden" id="itemd_hidden" disabled onkeypress="keyset('qty',event);" onblur="itno_ind();">
                                </div>
                                <div class="col-md-4 p-0" style="padding-left: 5px !important;">
                                    <label>Description</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="itemd" id="itemd" disabled onkeypress="keyset('rate',event);">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" onclick="NewWindow('serach_item.php?stname=quot','mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-1 p-0" style="padding-left: 5px !important;">
                                    <label>Rate</label>
                                    <input type="text" class="form-control input-sm" name="rate" id="rate" onkeypress="keyset('qty',event);">
                                    <input type="hidden" name="actual_selling" id="actual_selling">
                                    <input type="hidden" name="part_no" id="part_no">
                                </div>
                                <div class="col-md-1 p-0" style="padding-left: 5px !important;">
                                    <label>Qty</label>
                                    <input type="text" class="form-control input-sm" name="qty" id="qty" onblur="calc1();" onkeypress="keyset('discountper',event);">
                                </div>
                                <div class="col-md-1 p-0" style="padding-left: 5px !important;">
                                    <label>Disc %</label>
                                    <input type="text" class="form-control input-sm" name="discountper" id="discountper" onblur="calc1();" onkeypress="keyset('additem_tmp',event);">
                                    <input type="hidden" name="discount" id="discount" disabled>
                                </div>
                                <div class="col-md-2 p-0" style="padding-left: 5px !important;">
                                    <label>Sub Total</label>
                                    <input type="text" class="form-control input-sm" name="subtotal" id="subtotal" disabled onkeypress="keyset('additem_tmp',event);">
                                </div>
                                <div class="col-md-1 p-0" style="padding-left: 5px !important; padding-top: 25px;">
                                    <label></label>
                                    <input type="button" name="additem_tmp" id="additem_tmp" value="Add" onclick="add_tmp();" class="btn btn-primary btn-sm btn-block">
                                </div>
                            </div>
                            
                            <div class="row mt-10">
                                <div class="col-md-12">
                                    <div id="itemdetails">
                                        <!-- AJAX Content Loads Here -->
                                    </div>
                                </div>
                            </div>
                            
                            <hr>
                            
                            <!-- Totals Section -->
                            <div class="row">
                                <div class="col-md-9">
                                    <!-- Left side totals or notes -->
                                </div>
                                <div class="col-md-3">
                                    <div class="form-horizontal">
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Sub Total</label>
                                            <div class="col-sm-4">
                                                <input type="text" class="form-control input-sm" name="subtot" id="subtot" value="0" disabled>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Discount</label>
                                            <div class="col-sm-4">
                                                <input type="text" class="form-control input-sm" name="totdiscount" id="totdiscount" value="0" disabled>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Tax <span id="taxname"></span></label>
                                            <div class="col-sm-4">
                                                <input type="text" class="form-control input-sm" name="tax" id="tax" value="0" disabled>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label" style="font-size: 16px;">Invoice Total</label>
                                            <div class="col-sm-4">
                                                <input type="text" class="form-control input-lg" name="invtot" id="invtot" value="0" disabled style="font-weight: bold;">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Credit Period</label>
                                            <div class="col-sm-4">
                                                <input type="text" class="form-control input-sm" name="txt_deldays" id="txt_deldays">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Payment Term</label>
                                            <div class="col-sm-4">
                                                <select name="txt_paytype" id="txt_paytype" class="form-control input-sm"> 
                                                     <option value="CASH">CASH</option>
                                                     <option value="CREDIT">CREDIT</option> 
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Validity</label>
                                            <div class="col-sm-4">
                                                <input type="text" class="form-control input-sm" name="txt_validity" id="txt_validity">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </form>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div><!-- /.col -->
        </div><!-- /.row -->

    </section>
</div>

<script>
    // Keyboard Shortcut for Logout (Ctrl+Q)
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
            event.preventDefault();
            window.location.href = 'logout.php';
        }
    });
</script>
</body>
</html>
