<?php 
session_start();
require_once("connectioni.php");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Purchase Order</title>
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <!-- Scripts -->
    <script type="text/javascript" src="js/get_cat_description.js"></script>
    <script type="text/javascript" src="js/datepickr.js"></script>
    <!-- <script type="text/javascript" src="js/css.js"></script> Legacy removed -->
    <!-- <script type="text/javascript" src="js/behaviour.js"></script> Legacy removed -->
    
    <!-- Main Logic -->
    <script language="JavaScript" src="js/pur_ord.js"></script>

    <!-- Popup Window Script -->
    <script language="javascript" type="text/javascript">
    var win=null;
    function NewWindow(mypage,myname,w,h,scroll,pos){
        if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
        if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
        else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
        settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
        win=window.open(mypage,myname,settings);
    }
    </script>
    
    <!-- Initial Load Script -->
    <script type="text/javascript">
     window.onload = function(){
        new_inv(); // Initialize
     };
    </script>

    <style>
        body {
            background-color: #ecf0f5; /* Light grey background for ERP feel */
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles from pos_inv.php */
        .navbar-custom {
            background-color: #2c3e50; /* Primary Color */
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c; /* Danger Color */
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }
        
        /* Box/Card Styling */
        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
        }
        .box.box-primary {
            border-top-color: #3c8dbc;
        }
        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
        }
        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
        }
        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }
        .control-label {
            font-weight: 600;
            text-align: left !important; /* ERP convention */
            padding-top: 7px;
        }
        
        /* Buttons */
        .btn {
            border-radius: 3px;
            box-shadow: none;
            border: 1px solid transparent;
        }

        /* Table Styling Overrides (for AJAX Content) */
        #itemdetails table {
            width: 100%;
            margin-bottom: 20px;
            border: 1px solid #f4f4f4;
            border-collapse: collapse;
            font-size: 13px;
        }
        #itemdetails table th, #itemdetails table td {
            padding: 8px;
            line-height: 1.42857143;
            vertical-align: top;
            border: 1px solid #ddd;
        }
        #itemdetails table tr:first-child td {
            background-color: #3c8dbc !important;
            color: white !important;
            font-weight: bold;
            border-bottom: 2px solid #3c8dbc;
        }

        /* Utility */
        .mt-10 { margin-top: 10px; }
        .mb-10 { margin-bottom: 10px; }
        .p-0 { padding: 0 !important; }
        
        /* Specific overrides for legacy behavior */
        .hidden { display: none; }
        input[disabled], select[disabled], textarea[disabled] {
            cursor: not-allowed;
            background-color: #eee;
            opacity: 1;
        }
    </style>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        
        <div class="page-title-box">
            Purchase Order
        </div>
        
        <div class="user-info">
            <span>Welcome, <span class="user-name"><?php echo $_SESSION['user_name']; ?></span> [<?php echo $_SESSION['company']; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

<div class="content-wrapper">
    <section class="content">

        <!-- Action Toolbar -->
        <div class="box box-solid">
            <div class="box-body">
                <a onclick="new_inv();" class="btn btn-app">
                    <i class="fa fa-plus"></i> New
                </a>
                <a onclick="save_inv();" class="btn btn-app">
                    <i class="fa fa-save"></i> Save
                </a>
                <a onclick="update_inv();" class="btn btn-app">
                    <i class="fa fa-edit"></i> Update
                </a>
                <a onclick="cancel_inv();" class="btn btn-app">
                    <i class="fa fa-ban"></i> Cancel
                </a>
                <a onclick="print_inv();" class="btn btn-app">
                    <i class="fa fa-print"></i> Print
                </a>
                <a onclick="close_form();" class="btn btn-app">
                    <i class="fa fa-close"></i> Close
                </a>
            </div>
        </div>

        <div class="row">
            <!-- Left Column: Primary Details -->
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Purchase Order Details</h3>
                    </div>
                    <div class="box-body">
                        <form role="form" name="form1" id="form1" class="form-horizontal">
                            
                            <!-- Row 1: PO No, Date -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">PO No</label>
                                <div class="col-sm-2">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="invno" id="invno" disabled onkeypress="keyset('searchcust',event);" onblur="purord_ind('ord');">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="search_purord.php?stname=ord" onclick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-1 control-label">Entry Date</label>
                                <div class="col-sm-2">
                                    <input type="date" class="form-control input-sm" name="invdate" id="invdate" value="<?php echo date("Y-m-d"); ?>">
                                </div>
                                <div class="col-sm-3">
                                     <!-- Hidden Schedule Date -->
                                     <input type="hidden" name="dte_shedule" id="dte_shedule">
                                </div>
                            </div>

                            <!-- Row 2: Supplier & PI No -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Supplier</label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="supplier_code" id="supplier_code" disabled onblur="suppno_ind('purord');" onkeypress="keyset('salesrep',event);">
                                </div>
                                <div class="col-sm-3">
                                     <div class="input-group">
                                         <input type="text" class="form-control input-sm" name="supplier_name" id="supplier_name" disabled>
                                         <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="" onClick="NewWindow('serach_supplier.php?stname=purord','mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                         </span>
                                     </div>
                                </div>
                                
                                <label class="col-sm-1 control-label">PI No</label>
                                <div class="col-sm-1">
                                    <input type="text" class="form-control input-sm" name="pi_no" id="pi_no">
                                </div>
                            </div>

                            <!-- Row 3: Address, LC/TT, Brand -->
                             <div class="form-group">
                                <label class="col-sm-1 control-label">Address</label>
                                <div class="col-sm-5">
                                    <input type="text" class="form-control input-sm" name="address" id="address" disabled>
                                </div>
                                
                                <label class="col-sm-1 control-label">LC/TT No</label>
                                <div class="col-sm-1">
                                    <input type="text" class="form-control input-sm" name="lc_no" id="lc_no">
                                </div>

                                <label class="col-sm-1 control-label">Brand</label>
                                <div class="col-sm-2">
                                    <select name="brand" id="brand" class="form-control input-sm" onkeypress="keyset('searchitem',event);" onchange="assignbrandsession();">
                                        <?php
                                        if (($_SESSION["CURRENT_DEP"] != "") and (!is_numeric($_SESSION["CURRENT_DEP"]))) {
                                            $sql="select * from brand_mas where act ='1' and costcenter='".$_SESSION["CURRENT_DEP"]."' order by barnd_name"; 
                                        }else{
                                            $sql="select * from brand_mas where act ='1' order by barnd_name";
                                        } 
                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                        while($row = mysqli_fetch_array($result)){
                                            echo "<option value='".$row["barnd_name"]."'>".$row["barnd_name"]."</option>";
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            
                            <!-- Row 4: BL No, Country, CI No, Department -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">BL No</label>
                                <div class="col-sm-2">
                                     <input type="text" class="form-control input-sm" name="blno" id="blno">
                                </div>

                                <label class="col-sm-1 control-label">Country</label>
                                <div class="col-sm-2">
                                    <select name="country" id="country" class="form-control input-sm" onkeypress="keyset('searchitem',event);"> 
                                        <?php 
                                        $sql="select * from country "; 
                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                        while($row = mysqli_fetch_array($result)){
                                            echo "<option value='".$row["name"]."'>".$row["name"]." </option>";
                                        }
                                        ?>
                                    </select>
                                </div>

                                <label class="col-sm-1 control-label">CI No</label>
                                <div class="col-sm-1">
                                    <input type="text" class="form-control input-sm" name="invno1" id="invno1">
                                </div>

                                <label class="col-sm-1 control-label">Dept</label>
                                <div class="col-sm-2">
                                     <select name="department" id="department" class="form-control input-sm" onkeypress="keyset('brand',event);" onchange="setord();">
                                        <?php
                                        if ($_SESSION["CURRENT_DEP"] != "") {
                                           $sql="select * from s_stomas where  act='1' and CODE='".$_SESSION["CURRENT_DEP"] ."' order by CODE";
                                        }else{
                                          $sql="select * from s_stomas where  act='1'  order by CODE";
                                        } 
                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                        while($row = mysqli_fetch_array($result)){
                                            echo "<option value='".$row["CODE"]."'>  ".$row["DESCRIPTION"]."</option>";
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>

                            <!-- Row 5: Order By, Remarks -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Order By</label>
                                <div class="col-sm-2">
                                    <select name="salesrep" id="salesrep" class="form-control input-sm" onkeypress="keyset('dte_dor',event);" onchange="setord();">
                                      <?php
                                        if ($_SESSION["MANAGER"]!="") { 			 						
                                            $sql="select * from s_salrep where pactive='1' and manager='".$_SESSION["MANAGER"]."'order by REPCODE"; 
                                        }else if ($_SESSION["CURRENT_REP"]=="") { 			 						
                                            $sql="select * from s_salrep where pactive='1' order by REPCODE";
                                        } else {
                                             $sql="select * from s_salrep where pactive='1' and repcode = '" . $_SESSION["CURRENT_REP"] ."' order by REPCODE";
                                        }
                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                        while($row = mysqli_fetch_array($result)){
                                            echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                        }
                                      ?>
                                    </select>
                                </div>
                                <label class="col-sm-1 control-label">Remark</label>
                                <div class="col-sm-4">
                                    <input type="text" class="form-control input-sm" name="remarks" id="remarks">
                                </div>
                            </div>
                            
                            <!-- Hidden Fields -->
                            <div id="edit_log" class="hidden"></div>

                            <hr>
                            <h4 class="box-title text-primary">Item Details</h4>
                            
                            <!-- Add New Item Row -->
                            <div class="row bg-info" style="padding: 10px; margin: 0; border-radius: 3px;">
                                <div class="col-md-1 p-0">
                                    <label>Item Code</label>
                                    <input type="text" class="form-control input-sm" name="itemd_hidden" id="itemd_hidden" onkeypress="keyset('qty',event);" onblur="itno_ind();">
                                </div>
                                <div class="col-md-3 p-0" style="padding-left: 5px !important;">
                                    <label>Description</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="itemd" id="itemd" disabled onkeypress="keyset('rate',event);">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="serach_item_purord.php" onClick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-1 p-0" style="padding-left: 5px !important;">
                                    <label>Pattern</label>
                                    <input type="text" class="form-control input-sm" name="partno" id="partno" disabled onkeypress="keyset('qty',event);">
                                </div>
                                <div class="col-md-1 p-0" style="padding-left: 5px !important;">
                                    <label>Quantity</label>
                                    <input type="number" class="form-control input-sm" name="qty" id="qty" onKeyPress="keyset('additem_tmp',event);">
                                </div>
                                <div class="col-md-2 p-0" style="padding-left: 5px !important;">
                                    <label>Rate</label>
                                    <input type="number" class="form-control input-sm" name="rate" id="rate" onKeyPress="keyset('additem_tmp',event);">
                                </div>
                                <div class="col-md-1 p-0" style="padding-left: 5px !important; padding-top: 25px;">
                                    <label></label>
                                    <input type="button" name="additem_tmp" id="additem_tmp" value="Add" onclick="add_tmp();" class="btn btn-primary btn-sm btn-block">
                                </div>
                            </div>
                            
                            <div class="row mt-10">
                                <div class="col-md-12">
                                    <div id="itemdetails">
                                        <!-- AJAX Content Loads Here -->
                                    </div>
                                </div>
                            </div>
                            
                            <hr>
                            
                            <!-- Totals Section -->
                            <div class="row">
                                <div class="col-md-6 pull-right">
                                    <div class="form-horizontal">
                                        <div class="form-group">
                                            <label class="col-sm-2 control-label">Total Quantity</label>
                                            <div class="col-sm-4">
                                                <input type="text" class="form-control input-lg" name="qtytot" id="qtytot" value="0" disabled style="font-weight: bold; text-align: right;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </form>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div><!-- /.col -->
        </div><!-- /.row -->

    </section>
</div>

<script>
    // Keyboard Shortcut for Logout (Ctrl+Q)
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
            event.preventDefault();
            window.location.href = 'logout.php';
        }
    });
</script>
</body>
</html>
