<?php
session_start();
require_once("connectioni.php");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Other Company Send List</title>
    
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <!-- DataTables -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.5.2/css/buttons.bootstrap.min.css">
    
    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles */
        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c;
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name { font-weight: bold; }

        .content-wrapper { padding: 20px; }
        .box { background: #fff; border-top: 3px solid #d2d6de; box-shadow: 0 1px 1px rgba(0,0,0,0.1); margin-bottom: 20px; border-radius: 3px; }
        .box.box-primary { border-top-color: #3c8dbc; }
        .box-header { color: #444; display: block; padding: 10px; position: relative; border-bottom: 1px solid #f4f4f4; }
        .box-body { padding: 20px; }
    </style>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
    
    <!-- DataTables Scripts -->
    <script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.print.min.js"></script>
    
    <script src="js/othersendlist.js"></script>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        <div class="page-title-box">OTHER SEND LIST</div>
        <div class="user-info">
            <span>Welcome, <span class="user-name"><?php echo isset($_SESSION['CURRENT_USER']) ? $_SESSION['CURRENT_USER'] : 'User'; ?></span> [<?php echo isset($_SESSION['company']) ? $_SESSION['company'] : ''; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

    <div class="content-wrapper">
        <section class="content">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Other Company Send List</h3>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table id="example" class="table table-striped table-bordered table-hover" style="width:100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>JOB NO</th>
                                    <th>INVOICE NO</th>
                                    <th>DATE</th>
                                    <th>CUSTOMER</th>
                                    <th>MAKE</th>
                                    <th>SIZE</th>
                                    <th>BELT</th>
                                    <th>SERIAL NO</th>
                                    <th>CASING COST</th>
                                    <th>REMARK</th>
                                    <th>COMPANY NAME</th>
                                    <th>SEND DATE</th>
                                    <th>HISTORY</th>
                                    <th>SEND TO INVOICE</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Modal for Invoice Details -->
    <div id="invoiceModal" class="modal fade" role="dialog">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">Send to Invoice Details</h4>
          </div>
          <div class="modal-body">
            <form id="invoiceForm">
                <input type="hidden" id="inv_id">
                
                <div class="form-group">
                    <label>Job No:</label>
                    <input type="text" class="form-control" id="inv_newjobno" placeholder="Enter New Job No">
                </div>
                <div class="form-group">
                    <label>Belt:</label>
                    <input type="text" class="form-control" id="inv_belt" placeholder="Enter Belt">
                </div>
                <div class="form-group">
                    <label>Cost:</label>
                    <input type="number" class="form-control" id="inv_cost" placeholder="Enter Cost">
                </div>
                <div class="form-group">
                    <label>Selling Price:</label>
                    <input type="number" class="form-control" id="inv_selling" placeholder="Enter Selling Price">
                </div>
                <div class="form-group">
                    <label>Remark:</label>
                    <input type="text" class="form-control" id="inv_remark" placeholder="Enter Remark">
                </div>
                <div class="form-group">
                    <label>Warranty:</label>
                    <input type="text" class="form-control" id="inv_warrenty" placeholder="Enter Warranty">
                </div>
            </form>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            <button type="button" class="btn btn-primary" onclick="save_invoice()">Save & Send</button>
          </div>
        </div>
      </div>
    </div>

    <script>
        document.addEventListener('keydown', function(event) {
            if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
                event.preventDefault();
                window.location.href = 'logout.php';
            }
        });
    </script>
</body>
</html>