<?php
session_start();
require_once("connection_sql.php");
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_POST['Command']) ? $_POST['Command'] : (isset($_GET['Command']) ? $_GET['Command'] : '');

if ($command == "get_list") {
    try {
        $sql = "select * from dag_item WHERE flag >'3' and cancel='0' and TYPE='SENDOTHER'";

        // Filter by company if needed
        // if(isset($_SESSION['company']) && $_SESSION['company'] != "" && $_SESSION['company'] != "ALL") {
        //     $sql .= " and company='".$_SESSION['company']."'";
        // }

        $sql .= " ORDER BY id DESC";

        $result = $conn->query($sql);

        $data = [];
        $i = 1;

        foreach ($result as $row) {

            // History Count Logic
            $sql1 = "Select count(*) as count from dag_item  where cancel='0'  and  serialno='" . $row['serialno'] . "' group by  serialno asc";
            $result_1 = $conn->query($sql1);
            $row_1 = $result_1->fetch();
            $history_count = $row_1['count'] ?? 0;

            // Status Logic
            $status_html = "";
            $status_bg = "";

            if ($row['reject'] == '0') {
                if ($row['flag'] == '0') {
                    $status_html = "ONHAND";
                    $status_bg = "yellow";
                } else if ($row['flag'] == '1') {
                    $status_html = "PRODUCTION";
                    $status_bg = "#acdcf3";
                } else if ($row['flag'] == '2') {
                    $status_html = "COMPLETE";
                    $status_bg = "#1ef51e";
                } else if ($row['flag'] == '3') {
                    $status_html = "OTHER COMPANY SEND";
                    $status_bg = "#1ef51e";
                } else if ($row['flag'] == '5') {
                    $status_html = "OTHER COMPANY RECEIVED";
                    $status_bg = "#1ef51e";
                } else if ($row['flag'] == '6') {
                    $status_html = "ONHAND TRANSFER PENDING";
                    $status_bg = "#1ef51e";
                } else if ($row['flag'] == '7') {
                    $status_html = "INVOICED";
                    $status_bg = "#eabf5d";
                }
            } else {
                if ($row['flag'] == '7') {
                    $status_html = "REJECTED & INVOICED";
                    $status_bg = "red";
                } else {
                    $status_html = "REJECTED";
                    $status_bg = "red";
                }
            }

            $data[] = [
                'id' => $row['id'],
                'jobno' => $row['jobno'],
                'refno' => $row['refno'],
                'sdate' => $row['sdate'],
                'customer' => $row['cuscode'] . '-' . $row['cusname'],
                'marker' => $row['marker'],
                'size' => $row['size'],
                'belt' => $row['belt'],
                'serialno' => $row['serialno'],
                'cascost' => $row['cascost'],
                'cost' => $row['cost'],
                'total' => $row['total'], // Selling
                'remark' => $row['remark'],
                'ocompany' => $row['ocompany'],
                'onhand_date' => $row['onhand_date'],
                'com_date' => $row['com_date'], // Received Date
                'history_count' => $history_count,
                'status_html' => $status_html,
                'status_bg' => $status_bg
            ];
            $i++;
        }

        echo json_encode(['status' => 'success', 'data' => $data]);

    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "sendreject") {
    try {
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $conn->beginTransaction();

        $refno = $_POST['refno'] ?? '';
        $serialno = $_POST['serialno'] ?? '';

        $sql = "UPDATE dag_item set reject='1'  where refno='" . $refno . "' and  serialno='" . $serialno . "' and cancel='0'";
        $result = $conn->query($sql);

        $sqllog = "insert into entry_log(refno, username, docname, trnType, stime, sdate) values ('" . trim($refno) . "', '" . $_SESSION["CURRENT_USER"] . "', 'SEND RECEIVED LIST  TO REJECT', 'Save', '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d") . "')";
        $resultlog = $conn->query($sqllog);

        $conn->commit();
        echo json_encode(['status' => 'success', 'message' => 'SEND TO REJECT']);

    } catch (Exception $e) {
        $conn->rollBack();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}
?>