<?php
session_start();
require_once("connection_sql.php");
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_POST['Command']) ? $_POST['Command'] : (isset($_GET['Command']) ? $_GET['Command'] : '');

if ($command == "get_list") {
    try {
        $sql = "select * from dag_item WHERE flag='0' and cancel='0' and reject='0' ORDER BY id DESC";

        // Filter by company if needed (commented out in original, keeping logic available)
        // if(isset($_SESSION['company']) && $_SESSION['company'] != "" && $_SESSION['company'] != "ALL") {
        //     $sql = "select * from dag_item WHERE flag='0' and cancel='0' and reject='0' and company='".$_SESSION['company']."' ORDER BY id DESC";
        // }

        $result = $conn->query($sql);

        $data = [];
        $i = 1;

        foreach ($result as $row) {

            // History Count Logic
            $sql1 = "Select count(*) as count from dag_item  where cancel='0'  and  serialno='" . $row['serialno'] . "' group by  serialno asc";
            $result_1 = $conn->query($sql1);
            $row_1 = $result_1->fetch();
            $history_count = $row_1['count'] ?? 0;

            $data[] = [
                'id' => $row['id'],
                'jobno' => $row['jobno'],
                'refno' => $row['refno'],
                'sdate' => $row['sdate'],
                'customer' => $row['cuscode'] . '-' . $row['cusname'],
                'marker' => $row['marker'], // Make
                'size' => $row['size'],
                'belt' => $row['belt'],
                'serialno' => $row['serialno'],
                'cascost' => $row['cascost'],
                'remark' => $row['remark'],
                'history_count' => $history_count
            ];
            $i++;
        }

        echo json_encode(['status' => 'success', 'data' => $data]);

    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "sendother") {
    try {
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $conn->beginTransaction();

        $id = $_POST['id'] ?? '';
        $ocompany = $_POST['ocompany'] ?? '';

        if ($ocompany == "") {
            echo json_encode(['status' => 'error', 'message' => 'Enter Company Name']);
            exit;
        }

        $sql = "Select * from dag_item  where id='" . $id . "'";
        $result = $conn->query($sql);
        if ($rowM = $result->fetch()) {
            $sql = "UPDATE dag_item set flag='3', oldjobno=jobno, ocompany='" . $ocompany . "', onhand_date='" . date("Y-m-d") . "', TYPE='SENDOTHER' where id='" . $id . "'";
            $conn->query($sql);

            $sqllog = "insert into entry_log(refno, username, docname, trnType, stime, sdate,company) values
            ('" . $rowM['jobno'] . "', '" . $_SESSION["CURRENT_USER"] . "', 'SEND ONHAND TO OTHER', 'Save', '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d") . "','" . $rowM['department'] . "')";
            $conn->query($sqllog);

            $conn->commit();
            echo json_encode(['status' => 'success', 'message' => 'SENDED']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Item not found']);
        }

    } catch (Exception $e) {
        $conn->rollBack();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "sendinvoice") {
    try {
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $conn->beginTransaction();

        $id = $_POST['id'] ?? '';

        $sql = "Select * from dag_item  where id='" . $id . "'";
        $result = $conn->query($sql);
        if ($rowM = $result->fetch()) {
            $sql = "UPDATE dag_item set flag='6', onhand_date='" . date("Y-m-d") . "', TYPE='SENDINVOICE' where id='" . $id . "'";
            $conn->query($sql);

            $sqllog = "insert into entry_log(refno, username, docname, trnType, stime, sdate,company) values
            ('" . $rowM['jobno'] . "', '" . $_SESSION["CURRENT_USER"] . "', 'SEND ONHAND TO INVOICE', 'Save', '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d") . "','" . $rowM['department'] . "')";
            $conn->query($sqllog);

            $conn->commit();
            echo json_encode(['status' => 'success', 'message' => 'SEND INVOICE']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Item not found']);
        }

    } catch (Exception $e) {
        $conn->rollBack();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

// Fallback
echo json_encode(['status' => 'error', 'message' => 'Invalid Command']);
?>