
// Return Cheque Entry JavaScript (Refactored for Fetch/JSON)

// --- Utility Functions ---

function get_value(id) {
	let el = document.getElementById(id);
	return el ? el.value : "";
}

function set_value(id, val) {
	let el = document.getElementById(id);
	if (el) el.value = val;
}

function get_checkbox(id) {
	let el = document.getElementById(id);
	return el ? el.checked : false;
}

// --- Main Operations ---

async function new_inv() {
	clear();

	try {
		let chk_crenote = get_value('chk_crenote');
		let response = await fetch(`ret_cheque_entry_data.php?Command=new_inv&chk_crenote=${chk_crenote}&dev=1`);
		let data = await response.json();

		if (data.status === 'success') {
			set_value('lblReciptNo', data.invno);
			// set_value('DTPicker1', data.curdate);
		} else {
			alert(data.message);
		}
	} catch (error) {
		console.error("Error:", error);
	}
}

function clear() {
	set_value('lblReciptNo', '');
	set_value('com_dep', '');
	set_value('Txtcusco', '');
	set_value('txtcusname', '');
	set_value('txtChequeNo', '');
	document.getElementById('Check1').checked = false;
	set_value('DTPicker2', '');
	set_value('cmbBankname', '');
	set_value('txtChequeAmount', '');
	set_value('cheq_dpo_bank', '');
	set_value('txtcrenoteno', '');
	set_value('txtcrenoteamo', '');
	set_value('lblretdate', '');
	set_value('lblRET_chno', '');
	set_value('lblnoof', '');
	set_value('txtRetChCha', '');
	set_value('txtforwhat', '');
	set_value('txtremark', '');
	set_value('reason', '1');
}

async function save_inv() {
	let refno = get_value('lblReciptNo');
	let amount = get_value('txtChequeAmount');

	if (refno === "") {
		alert("Cheque no Is not Entered");
		return;
	}
	if (amount == 0 || amount === "") {
		alert("Cheque Amount Is Invalid");
		return;
	}

	let params = new URLSearchParams();
	params.append('Command', 'save_item');
	params.append('lblReciptNo', get_value('lblReciptNo'));
	params.append('chk_crenote', get_checkbox('chk_crenote'));
	params.append('com_dep', get_value('com_dep'));
	params.append('DTPicker1', get_value('DTPicker1')); // Entry Date
	params.append('com_costcent', get_value('com_costcent'));
	params.append('com_rep', get_value('com_rep'));
	params.append('Txtcusco', get_value('Txtcusco'));
	params.append('txtcusname', get_value('txtcusname'));
	params.append('txtChequeNo', get_value('txtChequeNo'));
	params.append('Check1', get_checkbox('Check1'));
	params.append('DTPicker2', get_value('DTPicker2')); // Cheque Date
	params.append('cmbBankname', get_value('cmbBankname'));
	params.append('txtChequeAmount', get_value('txtChequeAmount'));
	params.append('cheq_dpo_bank', get_value('cheq_dpo_bank'));
	params.append('txtcrenoteno', get_value('txtcrenoteno'));
	params.append('txtcrenoteamo', get_value('txtcrenoteamo'));
	params.append('lblretrefno', get_value('lblretrefno'));
	params.append('lblretdate', get_value('lblretdate')); // Ret. Cheque Date
	params.append('lblRET_chno', get_value('lblRET_chno'));
	params.append('lblnoof', get_value('lblnoof'));
	params.append('op_computer', get_checkbox('op_computer'));
	params.append('txtRetChCha', get_value('txtRetChCha'));
	params.append('txtforwhat', get_value('txtforwhat'));
	params.append('reason', get_value('reason')); // Added reason field
	params.append('txtremark', get_value('txtremark'));

	// Bank St Date (Missing in original JS but needed in PHP)
	// Assuming DTPicker1 as default or add a new field if UI has it
	params.append('bank_st_date', get_value('DTPicker1'));

	// Legacy Dev param
	params.append('txt_stat', 'NEW'); // Or EDIT

	try {
		let response = await fetch(`ret_cheque_entry_data.php?${params.toString()}`);
		let data = await response.json();

		if (data.status === 'success') {
			alert(data.message);
			location.reload();
		} else {
			alert(data.message);
		}
	} catch (error) {
		console.error("Error:", error);
	}
}

async function cancel_inv() {
	if (!confirm("Do you want to CANCEL this invoice?")) return;

	let params = new URLSearchParams();
	params.append('Command', 'cancel_inv');
	params.append('lblReciptNo', get_value('lblReciptNo'));
	params.append('txtChequeNo', get_value('txtChequeNo'));
	params.append('Txtcusco', get_value('Txtcusco'));
	params.append('cmbBankname', get_value('cmbBankname'));

	try {
		let response = await fetch(`ret_cheque_entry_data.php?${params.toString()}`);
		let data = await response.json();

		if (data.status === 'success') {
			alert(data.message);
			location.reload();
		} else {
			alert(data.message);
		}
	} catch (error) {
		console.error("Error:", error);
	}
}

// --- Popup Integration (Legacy Support) ---

function search_cheque() {
	// Calls existing search_ret_cheq.php
	// Note: search_ret_cheq.php needs to be updated to call ret_chq here
	window.open("search_ret_cheq.php?stname=ret_check", "mywin", "width=800, height=700");
}

function ret_chq(refno, stname) {
	// Callback from search_ret_cheq.php
	get_cheque_details(refno);
}

async function get_cheque_details(refno) {
	try {
		let response = await fetch(`ret_cheque_entry_data.php?Command=get_cheque&refno=${refno}`);
		let data = await response.json();

		if (data.status === 'success') {
			let d = data.data;
			set_value('lblReciptNo', d.CR_REFNO);
			set_value('Txtcusco', d.CR_C_CODE);
			set_value('txtcusname', d.CR_C_NAME);
			set_value('txtChequeNo', d.CR_CHNO);
			set_value('cmbBankname', d.CR_BANK);
			set_value('txtChequeAmount', d.CR_CHEVAL);
			set_value('DTPicker1', d.CR_DATE);
			set_value('DTPicker2', d.CR_CHDATE);
			set_value('cheq_dpo_bank', d.depobank);
			set_value('com_dep', d.DEPARTMENT);
			set_value('com_rep', d.S_REF);
			set_value('reason', d.reason);
			set_value('txtremark', d.REMARK);

			// Auto-set return date to today if empty
			if (get_value('lblretdate') === '') set_value('lblretdate', new Date().toISOString().split('T')[0]);

		} else {
			alert(data.message);
		}
	} catch (error) {
		console.error("Error:", error);
	}
}

function close_form() {
	window.location.href = "index.php";
}

function print_inv() {
	window.open("rep_inv.php?invno=" + get_value('lblReciptNo'));
}

// Initial Load
window.onload = function () {
	new_inv();
};
