var defectiveData = {
    items: []
};

document.addEventListener("DOMContentLoaded", function () {
    new_inv();

    // Add Event Listener for Item Code enter key
    document.getElementById('itemno').addEventListener("keypress", function (e) {
        if (e.key === 'Enter') {
            e.preventDefault();
            loadItem(this.value);
        }
    });

    // Calculations
    document.getElementById('qty').addEventListener("blur", calculateLine);
    document.getElementById('rate').addEventListener("blur", calculateLine);
    document.getElementById('discou').addEventListener("blur", calculateLine);
});

function new_inv() {
    fetch('defective_item_data.php?Command=new_inv')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                document.getElementById('txtrefno').value = data.refno;
                document.getElementById('dtdate').value = data.date;

                // Clear fields
                document.getElementById('txt_cuscode').value = '';
                document.getElementById('txt_cusname').value = '';
                document.getElementById('txtadd').value = '';
                document.getElementById('txtremark').value = '';
                document.getElementById('txtcl_no').value = '';
                document.getElementById('txtbat').value = '';
                document.getElementById('Cmbres').value = '';
                document.getElementById('txt_net').value = '0.00';

                defectiveData.items = [];
                renderItems();
            }
        });
}

function defect(refno) {
    // Callback from Search Popup (Claim List)
    fetch(`defective_item_data.php?Command=load_claim&refno=${refno}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                const rec = data.data;
                document.getElementById('txtcl_no').value = rec.cl_no || rec.refno;
                document.getElementById('txt_cuscode').value = rec.code || ''; // Adjust field mapping
                document.getElementById('txt_cusname').value = rec.cus_name || '';
                document.getElementById('txtadd').value = rec.address || '';
                document.getElementById('txtbat').value = rec.bat_no || '';

                // If the claim has item info, perform loadItem logic
                if (rec.stk_no) {
                    loadItem(rec.stk_no);
                }
            }
        });
}

function loadItem(itemCode) {
    if (!itemCode) return;
    fetch(`defective_item_data.php?Command=get_item&itemCode=${itemCode}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                document.getElementById('itemno').value = data.data.STK_NO;
                document.getElementById('item_name').value = data.data.DESCRIPT;
                document.getElementById('rate').value = data.data.SELLING;
                document.getElementById('qty').value = 1;
                document.getElementById('qty').focus();
            } else {
                alert("Item not found");
            }
        });
}

function calculateLine() {
    const rate = parseFloat(document.getElementById('rate').value) || 0;
    const qty = parseFloat(document.getElementById('qty').value) || 0;
    const disc = parseFloat(document.getElementById('discou').value) || 0;

    const sub = rate * qty;
    const discountAmount = sub * (disc / 100);
    const total = sub - discountAmount;

    document.getElementById('subtot').value = sub.toFixed(2);
    document.getElementById('total').value = total.toFixed(2);
}

function add_tmp() {
    // Add item to list
    const itemCode = document.getElementById('itemno').value;
    const itemName = document.getElementById('item_name').value;
    const rate = parseFloat(document.getElementById('rate').value) || 0;
    const qty = parseFloat(document.getElementById('qty').value) || 0;
    const disc = parseFloat(document.getElementById('discou').value) || 0;
    const total = parseFloat(document.getElementById('total').value) || 0;

    if (!itemCode || qty <= 0) {
        alert("Invalid Item or Qty");
        return;
    }

    defectiveData.items.push({
        itemCode, itemName, rate, qty, disc, total
    });

    renderItems();

    // Clear item inputs
    document.getElementById('itemno').value = '';
    document.getElementById('item_name').value = '';
    document.getElementById('rate').value = '';
    document.getElementById('qty').value = '';
    document.getElementById('discou').value = '';
    document.getElementById('subtot').value = '';
    document.getElementById('total').value = '';
    document.getElementById('itemno').focus();
}

function renderItems() {
    let html = '<table class="table table-bordered table-striped"><thead><tr><th>Item</th><th>Description</th><th>Rate</th><th>Qty</th><th>Disc %</th><th>Total</th><th>Action</th></tr></thead><tbody>';
    let grandTotal = 0;

    defectiveData.items.forEach((item, index) => {
        html += `<tr>
            <td>${item.itemCode}</td>
            <td>${item.itemName}</td>
            <td>${item.rate.toFixed(2)}</td>
            <td>${item.qty}</td>
            <td>${item.disc}</td>
            <td>${item.total.toFixed(2)}</td>
            <td><button class="btn btn-danger btn-xs" onclick="removeItem(${index})"><i class="fa fa-trash"></i></button></td>
        </tr>`;
        grandTotal += item.total;
    });

    html += '</tbody></table>';
    document.getElementById('itemdetails').innerHTML = html;
    document.getElementById('txt_net').value = grandTotal.toFixed(2);
}

function removeItem(index) {
    defectiveData.items.splice(index, 1);
    renderItems();
}

function save_inv() {
    if (defectiveData.items.length === 0) {
        alert("No items to save");
        return;
    }

    const payload = new FormData();
    payload.append('Command', 'save_item');
    payload.append('txtrefno', document.getElementById('txtrefno').value);
    // ... Append other fields
    payload.append('dtdate', document.getElementById('dtdate').value);
    payload.append('txt_cuscode', document.getElementById('txt_cuscode').value);
    payload.append('txt_cusname', document.getElementById('txt_cusname').value);
    payload.append('txt_net', document.getElementById('txt_net').value);
    payload.append('txtremark', document.getElementById('txtremark').value);

    payload.append('com_dep', document.getElementById('com_dep').value);
    payload.append('Com_rep', document.getElementById('Com_rep').value);

    payload.append('txtcl_no', document.getElementById('txtcl_no').value);
    payload.append('Cmbres', document.getElementById('Cmbres').value);

    payload.append('items', JSON.stringify(defectiveData.items));

    fetch('defective_item_data.php', {
        method: 'POST',
        body: payload
    })
        .then(res => res.json())
        .then(data => {
            alert(data.message);
            if (data.status === 'success') {
                new_inv();
            }
        });
}


function close_form() {
    window.close();
}

// Search Popups
function NewWindow(mypage, myname, w, h, scroll) {
    var winl = (screen.width - w) / 2;
    var wint = (screen.height - h) / 2;
    winprops = 'height=' + h + ',width=' + w + ',top=' + wint + ',left=' + winl + ',scrollbars=' + scroll + ',resizable'
    win = window.open(mypage, myname, winprops)
    if (parseInt(navigator.appVersion) >= 4) { win.window.focus(); }
}