
var itemList = [];

document.addEventListener('DOMContentLoaded', function () {
    loadInitialData();
});

function loadInitialData() {
    fetch('dag_purchase_data.php?Command=get_initial_data')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                populateSelect('department', data.data.departments, 'code', 'description');
                populateSelect('size', data.data.sizes, 'name', 'name');
                populateSelect('marker', data.data.markers, 'name', 'name');
                populateSelect('belt', data.data.belts, 'name', 'name');
            }
        });
}

function populateSelect(id, items, valKey, textKey) {
    const el = document.getElementById(id);
    if (!el) return;
    let html = '<option value="">Select</option>';
    items.forEach(item => {
        html += `<option value="${item[valKey]}">${item[textKey]}</option>`;
    });
    el.innerHTML = html;
}

function new_inv() {
    fetch('dag_purchase_data.php?Command=get_new_refno')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                document.getElementById('refno').value = data.refno;
                document.getElementById('sdate').value = data.sdate;

                // Clear inputs
                document.getElementById('cuscode').value = '';
                document.getElementById('cusname').value = '';
                document.getElementById('invno').value = '';
                document.getElementById('invdate').value = '';
                document.getElementById('adpayment').value = '';

                // Clear Item inputs
                clearItemInputs();

                // Clear List
                itemList = [];
                renderItemList();
                updateTotals();

                document.getElementById('department').disabled = false;
            }
        });
}

function clearItemInputs() {
    document.getElementById('jobno').value = '';
    document.getElementById('serialno').value = '';
    document.getElementById('cascost').value = '';
    document.getElementById('selling').value = '';
    document.getElementById('remark').value = '';
    document.getElementById('dagtype').value = ''; // Reset type
    // Reset selects
    // document.getElementById('size').value = ''; // Keep request? Or reset? Legacy reset.
    $('#size').val('');
    $('#marker').val('');
    $('#belt').val('');
    $('#warranty').val('YES');
}

function setjobno() {
    // Legacy behavior: getting jobno based on dept?
    // Modern: Maybe just unlock field or generate
    fetch('dag_purchase_data.php?Command=get_next_jobno')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                document.getElementById('jobno').value = data.jobno;
            }
        });
}

function add_tmp() {
    // Validation
    const cuscode = document.getElementById('cuscode').value;
    const item = {
        jobno: document.getElementById('jobno').value,
        serialno: document.getElementById('serialno').value,
        marker: document.getElementById('marker').value,
        size: document.getElementById('size').value,
        belt: document.getElementById('belt').value,
        warranty: document.getElementById('warranty').value,
        remark: document.getElementById('remark').value,
        cascost: document.getElementById('cascost').value || 0,
        selling: document.getElementById('selling').value || 0,
        dagtype: document.getElementById('dagtype').value
    };

    if (!cuscode) { alert("Select Customer"); return; }
    if (!item.jobno) { alert("Enter Job No"); return; }
    if (!item.serialno) { alert("Enter Serial No"); return; }

    itemList.push(item);
    renderItemList();
    updateTotals();
    clearItemInputs();

    // Lock department after first item?
    document.getElementById('department').disabled = true;
}

function renderItemList() {
    const tbody = document.getElementById('item_list_body');
    tbody.innerHTML = '';
    if (itemList.length === 0) {
        tbody.innerHTML = '<tr><td colspan="8" class="text-center text-muted">No items</td></tr>';
        return;
    }

    itemList.forEach((item, index) => {
        const tr = document.createElement('tr');
        tr.innerHTML = `
            <td>${item.jobno}</td>
            <td>${item.serialno}</td>
            <td>${item.dagtype}</td>
            <td>${item.size}</td>
            <td>${item.marker}</td>
            <td>${item.belt}</td>
            <td class="text-right">${parseFloat(item.cascost).toFixed(2)}</td>
            <td><button class="btn btn-danger btn-xs" onclick="removeItem(${index})"><i class="fa fa-trash"></i></button></td>
        `;
        tbody.appendChild(tr);
    });
}

function removeItem(index) {
    itemList.splice(index, 1);
    renderItemList();
    updateTotals();
}

function updateTotals() {
    let subtotal = 0;
    itemList.forEach(item => subtotal += parseFloat(item.cascost || 0));

    document.getElementById('subtot').value = subtotal.toFixed(2);

    // Calc Tax
    // Check Radio
    let taxRate = 0;
    if (document.getElementById('vatgroup_0').checked) taxRate = 0.15; // VAT
    // Others 0?

    let tax = subtotal * taxRate;
    document.getElementById('tax').value = tax.toFixed(2);
    document.getElementById('gtot').value = (subtotal + tax).toFixed(2);
}

function save_inv() {
    if (itemList.length === 0) { alert("No items to save"); return; }

    if (!confirm("Save Invoice?")) return;

    let vatGroup = '0';
    if (document.getElementById('vatgroup_0').checked) vatGroup = '1';
    if (document.getElementById('vatgroup_2').checked) vatGroup = '2';

    const payload = {
        refno: document.getElementById('refno').value,
        sdate: document.getElementById('sdate').value,
        department: document.getElementById('department').value,
        cuscode: document.getElementById('cuscode').value,
        cusname: document.getElementById('cusname').value,
        invno: document.getElementById('invno').value,
        invdate: document.getElementById('invdate').value,
        vat_group: vatGroup,
        items: itemList
    };

    fetch('dag_purchase_data.php?Command=save_purchase', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(payload)
    })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                alert("Saved! " + data.refno);
                new_inv();
            } else {
                alert("Error: " + data.message);
            }
        });
}

// Search Window Support
function NewWindow(mypage, myname, w, h, scroll) {
    var winl = (screen.width - w) / 2;
    var wint = (screen.height - h) / 2;
    winprops = 'height=' + h + ',width=' + w + ',top=' + wint + ',left=' + winl + ',scrollbars=' + scroll + ',resizable';
    win = window.open(mypage, myname, winprops);
    if (parseInt(navigator.appVersion) >= 4) {
        win.window.focus();
    }
}

// Callback from Customer Search
function custno(code) {
    // If calling from customer search
    // We need to fetch details?
    // Or is it just setting code?
    // Legacy `custno` function called `pass_quot` which loaded a purchase entry.
    // BUT `dag_search.php` calls `custno`. 
    // `customer_search.php` usually calls `custno` too?
    // Let's implement dual logic: if code starts with C/ it is customer. If DAG/ it is entry.

    if (code.includes('C/')) {
        // Fetch Customer Details
        // We need a helper or just set code and wait for user to fill name?
        // Usually customer search fills name.
        document.getElementById('cuscode').value = code;
        // Assume search popup fills name or we fetch it.
    } else {
        // Load purchase
        loadPurchase(code);
    }
}

function loadPurchase(refno) {
    fetch(`dag_purchase_data.php?Command=search_purchase&refno=${refno}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                const h = data.data.header;
                document.getElementById('refno').value = h.refno;
                document.getElementById('sdate').value = h.sdate;
                document.getElementById('cuscode').value = h.cuscode;
                document.getElementById('cusname').value = h.cusname;
                document.getElementById('department').value = h.department;
                document.getElementById('invno').value = h.invno;

                itemList = data.data.items;
                renderItemList();
                updateTotals();
            }
        });
}

// Helper for Item Search Popup Response
// Legacy: pass_item_inv calls this locally?
// The popup calls `opener.pass_item_inv`.
function pass_item_inv(code) {
    // This function is called by the popup window `dag_purchase_dag_search.php`
    // It passes `cuscode` (item refno) and `stname`.
    // We should look up the item details and fill the form inputs.

    // We need an endpoint to get item details by refno/jobno
    // For now, let's assume we can define a get_item logic or just fill text fields if passed.
    // The popup seems to prompt selection.

    // Let's assume code is ID or RefNo.
    document.getElementById('jobno').value = code;
    // Fetch rest? 
    // Ideally `dag_purchase_dag_search.php` should pass full object or we fetch it.
    // Legacy updated `cascost`, `dagtype`, etc.
}

function calc() {
    updateTotals();
}