
// State Management
var transferList = [];

document.addEventListener('DOMContentLoaded', function () {
    loadDepartments();
    // new_inv() handled by inline script in view or check if we need to auto-load
});

function loadDepartments() {
    fetch('dag_gin_transfer_data.php?Command=get_departments')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                let options = '<option value="">Select Department</option>';
                data.data.forEach(dept => {
                    options += `<option value="${dept.code}">${dept.description}</option>`;
                });

                // Populate both selects if they exist
                if (document.getElementById('from_dep')) document.getElementById('from_dep').innerHTML = options;
                if (document.getElementById('to_dep')) document.getElementById('to_dep').innerHTML = options;
            }
        })
        .catch(err => console.error(err));
}

function new_inv() {
    // Reset inputs
    if (document.getElementById('invno')) document.getElementById('invno').value = '';
    if (document.getElementById('txtarno')) document.getElementById('txtarno').value = '';

    // Default dates and selects
    if (document.getElementById('sdate')) document.getElementById('sdate').value = new Date().toISOString().slice(0, 10);

    // Clear list
    transferList = [];
    renderTransferList();
}

function openSearchModal() {
    $('#item_modal_search').modal('show');
    setTimeout(() => document.getElementById('search_input').focus(), 500);
}

function searchItems() {
    const query = document.getElementById('search_input').value;
    const fromDep = document.getElementById('from_dep') ? document.getElementById('from_dep').value : '';

    fetch(`dag_gin_transfer_data.php?Command=search_items&query=${encodeURIComponent(query)}&from_dep=${encodeURIComponent(fromDep)}`)
        .then(response => response.json())
        .then(data => {
            const tbody = document.getElementById('search_results');
            tbody.innerHTML = '';

            if (data.status === 'success' && data.data.length > 0) {
                data.data.forEach(item => {
                    const tr = document.createElement('tr');
                    tr.innerHTML = `
                        <td>${item.jobno}</td>
                        <td>${item.serialno}</td>
                        <td>${item.marker}</td>
                        <td>${item.size}</td>
                        <td>${item.refno}</td>
                        <td><button class="btn btn-xs btn-success" onclick='selectItem(${JSON.stringify(item)})'>Select</button></td>
                    `;
                    tbody.appendChild(tr);
                });
            } else {
                tbody.innerHTML = '<tr><td colspan="6" class="text-center">No items found</td></tr>';
            }
        });
}

function selectItem(item) {
    if (transferList.some(i => i.jobno === item.jobno && i.serialno === item.serialno)) {
        alert('Item already in list');
        return;
    }

    // Formatting item to match list structure
    const newItem = {
        jobno: item.jobno,
        refno: item.refno,
        serialno: item.serialno,
        make: item.marker,
        size: item.size,
        cascost: item.cascost
    };

    transferList.push(newItem);
    renderTransferList();

    $('#item_modal_search').modal('hide');
    document.getElementById('search_input').value = '';
}

function searchItemByCode() {
    const jobno = document.getElementById('jobno_input').value;
    if (!jobno) return;

    fetch(`dag_gin_transfer_data.php?Command=get_item_details&jobno=${encodeURIComponent(jobno)}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                selectItem(data.data);
                document.getElementById('jobno_input').value = '';
            } else {
                alert('Item not found');
            }
        });
}

function renderTransferList() {
    const tbody = document.getElementById('item_list_body');
    if (!tbody) return; // Might be in search window

    tbody.innerHTML = '';

    if (transferList.length === 0) {
        tbody.innerHTML = '<tr><td colspan="7" class="text-center text-muted">No items added</td></tr>';
        return;
    }

    transferList.forEach((item, index) => {
        const tr = document.createElement('tr');
        tr.innerHTML = `
            <td>${item.jobno}</td>
            <td>${item.refno}</td>
            <td>${item.serialno}</td>
            <td>${item.make}</td>
            <td>${item.size}</td>
            <td>${item.cascost || '0'}</td>
            <td><button class="btn btn-xs btn-danger" onclick="removeFromList(${index})"><i class="fa fa-trash"></i></button></td>
        `;
        tbody.appendChild(tr);
    });
}

function removeFromList(index) {
    transferList.splice(index, 1);
    renderTransferList();
}

function saveTransfer() {
    if (transferList.length === 0) {
        alert("No items to transfer");
        return;
    }

    if (!confirm("Are you sure you want to save this GIN transfer?")) return;

    const payload = {
        sdate: document.getElementById('sdate').value,
        from_dep: document.getElementById('from_dep').value,
        to_dep: document.getElementById('to_dep').value,
        arno: document.getElementById('txtarno').value,
        items: transferList
    };

    fetch('dag_gin_transfer_data.php?Command=save_transfer', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(payload)
    })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                alert("Saved Successfully! Ref No: " + data.ref_no);
                document.getElementById('invno').value = data.ref_no;
                // new_inv(); // Optional: auto clear
                // location.reload(); 
            } else {
                alert("Error: " + data.message);
            }
        })
        .catch(err => alert("Network Error"));
}

function cancelTransfer() {
    if (confirm("Cancel current changes?")) {
        new_inv();
    }
}

// Legacy Search Window Support
function pass_inv(invno) {
    if (window.opener && !window.opener.closed) {
        window.opener.loadTransfer(invno);
        window.close();
    } else {
        alert("Main window not found. Please open this from the main module.");
    }
}

// Viewer Logic
function loadTransfer(invno) {
    fetch(`dag_gin_transfer_data.php?Command=pass_inv&invno=${invno}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                const header = data.data.header;

                document.getElementById('invno').value = header.invno;
                document.getElementById('sdate').value = header.sdate;
                document.getElementById('from_dep').value = header.from_dep;
                document.getElementById('to_dep').value = header.to_dep;
                if (document.getElementById('txtarno')) document.getElementById('txtarno').value = header.arno;

                // Populate List
                transferList = data.data.items;
                renderTransferList();
            } else {
                alert(data.message);
            }
        });
}

function openArnSearch() {
    NewWindow('serach_arn.php?mstatus=gin', 'mywin', '800', '700', 'yes', 'center');
}

// Helper for popup
function NewWindow(mypage, myname, w, h, scroll) {
    var winl = (screen.width - w) / 2;
    var wint = (screen.height - h) / 2;
    winprops = 'height=' + h + ',width=' + w + ',top=' + wint + ',left=' + winl + ',scrollbars=' + scroll + ',resizable';
    win = window.open(mypage, myname, winprops);
    if (parseInt(navigator.appVersion) >= 4) {
        win.window.focus();
    }
}

// Legacy Enter Key Support
function keyset(key, e) {
    if (e.keyCode == 13) {
        if (key === 'qty') document.getElementById('jobno_input').focus();
        // Simplified handling
    }
}
