
// DAG Module JavaScript (Modernized)

// --- Utility Functions ---

function get_value(id) {
    let el = document.getElementById(id);
    return el ? el.value : "";
}

function set_value(id, val) {
    let el = document.getElementById(id);
    if (el) el.value = val;
}

// --- Main Operations ---

async function new_inv() {
    clear();

    try {
        let department = get_value('department');
        let response = await fetch(`dag_data.php?Command=new_inv&department=${department}`);
        let data = await response.json();

        if (data.status === 'success') {
            set_value('refno', data.refno);
            set_value('uniq', data.uniq);
            set_value('sdate', data.sdate);

            // Enable/Disable controls
            document.getElementById('department').disabled = false;
            document.getElementById('itemdetails').innerHTML = "";
        } else {
            alert(data.message);
        }
    } catch (error) {
        console.error("Error:", error);
    }
}

function clear() {
    set_value('refno', '');
    set_value('cuscode', '');
    set_value('cusname', '');
    set_value('invno', '');
    set_value('jobno', '');
    set_value('serialno', '');
    set_value('remark', '');
    set_value('itemdetails', '');
    set_value('cascost', '');
    set_value('adpayment', '');

    // Clear dropdowns if needed, or index 0
    document.getElementById('size').value = "";
    document.getElementById('marker').value = "";
    document.getElementById('belt').value = "";
    document.getElementById('warranty').value = "YES";
}

async function setjobno() {
    let department = get_value('department');
    let refno = get_value('refno');

    try {
        let response = await fetch(`dag_data.php?Command=setjobno&department=${department}&refno=${refno}`);
        let data = await response.json();

        if (data.status === 'success') {
            set_value('jobno', data.jobno);
        }
    } catch (error) {
        console.error("Error:", error);
    }
}

async function add_tmp() {
    // Validation
    if (get_value('cuscode') === "") { alert("Select Customer"); return; }
    if (get_value('jobno') === "") { alert("Enter Job No"); return; }
    if (get_value('serialno') === "") { alert("Enter Serial No"); return; }

    let params = new URLSearchParams();
    params.append('Command', 'add_tmp');
    params.append('refno', get_value('refno'));
    params.append('uniq', get_value('uniq'));
    params.append('department', get_value('department'));

    params.append('cuscode', get_value('cuscode'));
    params.append('cusname', get_value('cusname'));

    params.append('jobno', get_value('jobno'));
    params.append('serialno', get_value('serialno'));
    params.append('warranty', get_value('warranty'));
    params.append('remark', get_value('remark'));

    params.append('size', get_value('size'));
    params.append('marker', get_value('marker'));
    params.append('belt', get_value('belt'));
    params.append('cascost', get_value('cascost'));
    params.append('dagtype', get_value('dagtype'));

    try {
        let response = await fetch(`dag_data.php`, {
            method: 'POST',
            body: params
        });
        let data = await response.json();

        if (data.status === 'success') {
            render_grid(data.items);
            // Clear item fields
            set_value('serialno', '');
            set_value('remark', '');
            set_value('jobno', ''); // Maybe keep jobno? Legacy cleared it.
        } else {
            alert(data.message);
        }
    } catch (error) {
        console.error("Error:", error);
    }
}

async function del_item(id) {
    if (!confirm("Remove this item?")) return;

    try {
        let response = await fetch(`dag_data.php?Command=del_item&id=${id}&uniq=${get_value('uniq')}&refno=${get_value('refno')}`);
        let data = await response.json();

        if (data.status === 'success') {
            render_grid(data.items);
        } else {
            alert(data.message);
        }
    } catch (error) {
        console.error("Error:", error);
    }
}

function render_grid(items) {
    let html = `<table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>Job No</th>
                <th>Serial No</th>
                <th>Make</th>
                <th>Size</th>
                <th>Warranty</th>
                <th>Cost</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>`;

    items.forEach(item => {
        html += `<tr>
            <td>${item.jobno}</td>
            <td>${item.serialno}</td>
            <td>${item.marker}</td>
            <td>${item.size}</td>
            <td>${item.warrenty}</td>
            <td>${item.cost}</td>
            <td><a class="btn btn-danger btn-xs" onclick="del_item(${item.id})"><i class="fa fa-trash"></i></a></td>
        </tr>`;
    });

    html += `</tbody></table>`;
    document.getElementById('itemdetails').innerHTML = html;
}

async function save_inv() {
    if (get_value('refno') === "") { alert("Ref No missing"); return; }

    let params = new URLSearchParams();
    params.append('Command', 'save_item');
    params.append('refno', get_value('refno'));
    params.append('uniq', get_value('uniq'));
    params.append('sdate', get_value('sdate'));
    params.append('cuscode', get_value('cuscode'));
    params.append('cusname', get_value('cusname'));
    params.append('department', get_value('department'));
    params.append('invno', get_value('invno'));
    params.append('adpayment', get_value('adpayment'));
    params.append('cascost', get_value('cascost'));

    try {
        let response = await fetch(`dag_data.php`, {
            method: 'POST',
            body: params
        });
        let data = await response.json();

        if (data.status === 'success') {
            alert(data.message);
            location.reload();
        } else {
            alert(data.message);
        }
    } catch (error) {
        console.error("Error:", error);
    }
}

async function cancel_inv() {
    if (!confirm("Cancel this DAG?")) return;

    try {
        let refno = get_value('refno');
        let response = await fetch(`dag_data.php?Command=cancel_inv&refno=${refno}`);
        let data = await response.json();

        if (data.status === 'success') {
            alert(data.message);
            location.reload();
        } else {
            alert(data.message);
        }
    } catch (error) {
        console.error("Error:", error);
    }
}

// Search Integration
function search_cust() {
    // Legacy call maintained
    // Assuming customer_search.php works and calls back proper function
    // If legacy uses `custno` as callback in `customer_search.php`, we need to support it.
    // But usually `customer_search.php` calls `opener.document.getElementById`.
    // We will stick to `NewWindow` as used in PHP.
    // If we need a function:
    let url = "customer_search.php?stname=dag"; // stname=dag might imply special logic
    window.open(url, "mywin", "width=800, height=700");
}

function custno(code) {
    // Callback from dag_search.php (Load Entry)
    // Legacy did: pass_quot
    get_dag_entry(code);
}

// Callback from customer_search.php if it uses function
function customer_selected(code, name) {
    set_value('cuscode', code);
    set_value('cusname', name);
}

async function get_dag_entry(refno) {
    try {
        let response = await fetch(`dag_data.php?Command=pass_quot&custno=${refno}`);
        let data = await response.json();

        if (data.status === 'success') {
            set_value('refno', data.refno);
            set_value('sdate', data.sdate);
            set_value('cuscode', data.cuscode);
            set_value('cusname', data.cusname);
            set_value('department', data.department);
            set_value('invno', data.invno);
            set_value('adpayment', data.adpayment);
            set_value('cascost', data.cascost);

            render_grid(data.items);

        } else {
            alert(data.message);
        }
    } catch (error) {
        console.error("Error:", error);
    }
}

function print_inv() {
    let refno = get_value('refno');
    window.open(`dag_print.php?refno=${refno}`, '_blank');
}

function close_form() {
    window.location.href = "index.php";
}

function NewWindow(mypage, myname, w, h, scroll) {
    var winl = (screen.width - w) / 2;
    var wint = (screen.height - h) / 2;
    var settings = 'height=' + h + ',width=' + w + ',top=' + wint + ',left=' + winl + ',scrollbars=' + scroll + ',resizable';
    window.open(mypage, myname, settings);
}

// Init
window.onload = function () {
    new_inv();
};