var chqExtendData = {};

document.addEventListener("DOMContentLoaded", function () {
	new_inv();
});

function new_inv() {
	fetch('chq_extend_data.php?Command=new_inv')
		.then(response => response.json())
		.then(data => {
			if (data.status === 'success') {
				document.getElementById('txtrefno').value = data.refno;
				document.getElementById('txtsdate').value = data.date;
				document.getElementById('txttime').value = data.time;

				// Clear fields
				document.getElementById('txtch_no').value = '';
				document.getElementById('txtcode').value = '';
				document.getElementById('txtname').value = '';
				document.getElementById('txtsal_ex').value = '';
				document.getElementById('txtch_amount').value = '';
				document.getElementById('txtch_date').value = '';
				document.getElementById('txtchexdate').value = '';
				document.getElementById('txtapproved').value = '';
				document.getElementById('Textposted').value = '';
				document.getElementById('ded').value = 'NO';

				document.getElementById('lblApproved').innerText = '';
				document.getElementById('lblAccApproved').innerText = '';

				document.getElementById('btnApprove').disabled = false;
				document.getElementById('btnDeny').disabled = false;

			}
		});
}

function chq_extn(chno, refno) {
	// Callback from Search Popup
	fetch(`chq_extend_data.php?Command=get_cheque_details&refno=${refno}`)
		.then(response => response.json())
		.then(data => {
			if (data.status === 'success') {
				const rec = data.data;
				document.getElementById('txtrefno').value = rec.refno;
				document.getElementById('txtch_no').value = rec.ch_no;
				document.getElementById('txtcode').value = rec.icode;
				document.getElementById('txtname').value = rec.cus_name;
				document.getElementById('txtsal_ex').value = rec.sal_ex;
				document.getElementById('txtch_amount').value = rec.ch_amount;
				document.getElementById('txtch_date').value = rec.ch_date;
				document.getElementById('txtchexdate').value = rec.ch_exdate;
				document.getElementById('ded').value = rec.ins || 'NO';

				document.getElementById('txtapproved').value = rec.approved_by || '';
				document.getElementById('Textposted').value = rec.acc_approved_by || '';

				document.getElementById('lblApproved').innerText = rec.approved;
				document.getElementById('lblAccApproved').innerText = rec.acc_approved;

				// Logic to disable buttons if already approved?
				if (rec.approved === 'YES') {
					document.getElementById('lblApproved').className = 'label label-success';
				} else {
					document.getElementById('lblApproved').className = 'label label-warning';
				}

				if (rec.acc_approved === 'YES') {
					document.getElementById('lblAccApproved').className = 'label label-success';
				} else {
					document.getElementById('lblAccApproved').className = 'label label-warning';
				}
			}
		});
}

function save_inv() {
	const payload = new FormData();
	payload.append('Command', 'save_item');
	payload.append('txtrefno', document.getElementById('txtrefno').value);
	payload.append('txtch_no', document.getElementById('txtch_no').value);
	payload.append('txtch_date', document.getElementById('txtch_date').value);
	payload.append('txtchexdate', document.getElementById('txtchexdate').value);
	payload.append('txtch_amount', document.getElementById('txtch_amount').value);
	payload.append('txtcode', document.getElementById('txtcode').value);
	payload.append('txtname', document.getElementById('txtname').value);
	payload.append('txtsal_ex', document.getElementById('txtsal_ex').value);
	payload.append('ded', document.getElementById('ded').value);

	fetch('chq_extend_data.php', {
		method: 'POST',
		body: payload
	})
		.then(res => res.json())
		.then(data => {
			alert(data.message);
			if (data.status === 'success') {
				// Reload?
			}
		});
}

function approve() {
	const refno = document.getElementById('txtrefno').value;
	if (!refno) return;

	if (confirm("Are you sure you want to Approve?")) {
		fetch(`chq_extend_data.php?Command=approve&refno=${refno}`)
			.then(res => res.json())
			.then(data => {
				alert(data.message);
				chq_extn(null, refno); // Reload
			});
	}
}

function deny() {
	const refno = document.getElementById('txtrefno').value;
	if (!refno) return;

	if (confirm("Are you sure you want to Deny?")) {
		fetch(`chq_extend_data.php?Command=deny&refno=${refno}`)
			.then(res => res.json())
			.then(data => {
				alert(data.message);
				chq_extn(null, refno); // Reload
			});
	}
}

function acc_approve() {
	const refno = document.getElementById('txtrefno').value;
	if (!refno) return;

	if (confirm("Are you sure you want to Account Approve?")) {
		fetch(`chq_extend_data.php?Command=acc_approve&refno=${refno}`)
			.then(res => res.json())
			.then(data => {
				alert(data.message);
				chq_extn(null, refno); // Reload
			});
	}
}

function acc_no() {
	const refno = document.getElementById('txtrefno').value;
	if (!refno) return;

	if (confirm("Are you sure you want to Account Reject?")) {
		fetch(`chq_extend_data.php?Command=acc_no&refno=${refno}`)
			.then(res => res.json())
			.then(data => {
				alert(data.message);
				chq_extn(null, refno); // Reload
			});
	}
}

function close_form() {
	window.close();
}


// Search Popups
function NewWindow(mypage, myname, w, h, scroll) {
	var winl = (screen.width - w) / 2;
	var wint = (screen.height - h) / 2;
	winprops = 'height=' + h + ',width=' + w + ',top=' + wint + ',left=' + winl + ',scrollbars=' + scroll + ',resizable'
	win = window.open(mypage, myname, winprops)
	if (parseInt(navigator.appVersion) >= 4) { win.window.focus(); }
}

// Callback from Cheque Search
function cheque(no, amount, date, bank, branch, cuscode, cusname, rep) {
	document.getElementById('txtch_no').value = no;
	document.getElementById('txtch_amount').value = amount;
	document.getElementById('txtch_date').value = date;
	document.getElementById('txtcode').value = cuscode;
	document.getElementById('txtname').value = cusname;
	document.getElementById('txtsal_ex').value = rep;
}
