
var chequeList = [];
var invoiceList = [];

document.addEventListener('DOMContentLoaded', function () {
    loadInitialData();
});

function loadInitialData() {
    fetch('advance_payment_data.php?Command=get_initial_data')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                populateSelect('salesrep', data.data.reps, 'code', 'name');
                populateSelect('accno', data.data.accounts, 'code', 'name');
            }
        });
}

function populateSelect(id, items, valKey, textKey) {
    const el = document.getElementById(id);
    if (!el) return;
    let html = '<option value="">Select</option>';
    items.forEach(item => {
        html += `<option value="${item[valKey]}">${item[valKey]} - ${item[textKey]}</option>`;
    });
    el.innerHTML = html;
}

function new_inv() {
    fetch('advance_payment_data.php?Command=new_rec')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                document.getElementById('invno').value = data.recno;
                document.getElementById('invdate').value = data.date;

                // Clear Inputs
                document.getElementById('cuscode').value = '';
                document.getElementById('cusname').value = '';
                document.getElementById('chqno').value = '';
                document.getElementById('chqdate').value = '';
                document.getElementById('bank').value = '';
                document.getElementById('chqamt').value = '';
                document.getElementById('cashtot').value = '';
                document.getElementById('remarks').value = '';

                chequeList = [];
                invoiceList = [];
                renderChequeList();
                renderInvoiceList();
                updateTotals();
            }
        });
}

// Called by Customer Search Popup
function custno(code) {
    // Determine if customer code
    if (code.startsWith('C') || code.includes('C/')) {
        document.getElementById('cuscode').value = code;
        // Fetch Invoices
        loadInvoices(code);
    }
}

function loadInvoices(cuscode) {
    fetch(`advance_payment_data.php?Command=get_customer_invoices&cuscode=${cuscode}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                invoiceList = data.invoices.map(inv => ({
                    ...inv,
                    settle_amount: 0 // Init settlement
                }));
                renderInvoiceList();
            }
        });
}

function renderInvoiceList() {
    const tbody = document.getElementById('invoice_list_body');
    if (!tbody) return;
    tbody.innerHTML = '';

    invoiceList.forEach((inv, index) => {
        const tr = document.createElement('tr');
        tr.innerHTML = `
            <td>${inv.refno}</td>
            <td>${inv.date}</td>
            <td class="text-right">${parseFloat(inv.amount).toFixed(2)}</td>
            <td class="text-right">${parseFloat(inv.paid).toFixed(2)}</td>
            <td class="text-right text-red">${parseFloat(inv.balance).toFixed(2)}</td>
            <td><input type="number" class="form-control input-sm text-right" 
                value="${inv.settle_amount}" 
                onchange="updateSettle(${index}, this.value)"
                max="${inv.balance}"></td>
        `;
        tbody.appendChild(tr);
    });
}

function updateSettle(index, val) {
    let amount = parseFloat(val) || 0;
    if (amount > invoiceList[index].balance) {
        amount = invoiceList[index].balance;
        // Alert?
    }
    invoiceList[index].settle_amount = amount;
    renderInvoiceList(); // Update UI to show corrected value if capped
    updateTotals();
}

function add_cheque() {
    const chq = {
        no: document.getElementById('chqno').value,
        date: document.getElementById('chqdate').value,
        bank: document.getElementById('bank').value,
        amount: parseFloat(document.getElementById('chqamt').value) || 0
    };

    if (!chq.no || !chq.amount) { alert("Missing Cheque Details"); return; }

    chequeList.push(chq);

    // Clear Chq Inputs
    document.getElementById('chqno').value = '';
    document.getElementById('chqamt').value = '';
    document.getElementById('bank').value = '';

    renderChequeList();
    updateTotals();
}

function renderChequeList() {
    const tbody = document.getElementById('cheque_list_body');
    if (!tbody) return;
    tbody.innerHTML = '';

    chequeList.forEach((chq, index) => {
        const tr = document.createElement('tr');
        tr.innerHTML = `
            <td>${chq.no}</td>
            <td>${chq.date}</td>
            <td>${chq.bank}</td>
            <td class="text-right">${parseFloat(chq.amount).toFixed(2)}</td>
            <td><button class="btn btn-danger btn-xs" onclick="removeCheque(${index})"><i class="fa fa-trash"></i></button></td>
        `;
        tbody.appendChild(tr);
    });
}

function removeCheque(index) {
    chequeList.splice(index, 1);
    renderChequeList();
    updateTotals();
}

function updateTotals() {
    let chqTotal = 0;
    chequeList.forEach(c => chqTotal += c.amount);
    document.getElementById('chqtot').value = chqTotal.toFixed(2);

    let cashTotal = parseFloat(document.getElementById('cashtot').value) || 0;

    let totalPay = chqTotal + cashTotal;

    // Update Invoice Settle Total
    let settleTotal = 0;
    invoiceList.forEach(inv => settleTotal += (parseFloat(inv.settle_amount) || 0));

    document.getElementById('txtpaytot').value = settleTotal.toFixed(2); // Selected Invoice Amount
    document.getElementById('txtoverpay').value = (totalPay - settleTotal).toFixed(2); // Over/Under
}

function auto_allocate() {
    let cash = parseFloat(document.getElementById('cashtot').value) || 0;
    let chq = parseFloat(document.getElementById('chqtot').value) || 0;
    let available = cash + chq;

    // Distribute available across invoices
    invoiceList.forEach(inv => {
        if (available > 0) {
            let needed = inv.balance;
            let pay = Math.min(needed, available);
            inv.settle_amount = pay;
            available -= pay;
        } else {
            inv.settle_amount = 0;
        }
    });
    renderInvoiceList();
    updateTotals();
}

function save_crec() {
    // Validate
    let totalPay = (parseFloat(document.getElementById('chqtot').value) || 0) + (parseFloat(document.getElementById('cashtot').value) || 0);
    if (totalPay <= 0) { alert("No Payment Entered"); return; }

    if (!document.getElementById('cuscode').value) { alert("Select Customer"); return; }

    const payload = {
        recno: document.getElementById('invno').value,
        date: document.getElementById('invdate').value,
        cuscode: document.getElementById('cuscode').value,
        amount: totalPay,
        payType: document.getElementById('paytype').value,
        cheques: chequeList,
        allocations: invoiceList
    };

    fetch('advance_payment_data.php?Command=save_receipt', {
        method: 'POST',
        body: JSON.stringify(payload),
        headers: { 'Content-Type': 'application/json' }
    })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                alert("Saved: " + data.recno);
                new_inv();
            } else {
                alert("Error: " + data.message);
            }
        });
}

function NewWindow(mypage, myname, w, h, scroll) {
    var winl = (screen.width - w) / 2;
    var wint = (screen.height - h) / 2;
    winprops = 'height=' + h + ',width=' + w + ',top=' + wint + ',left=' + winl + ',scrollbars=' + scroll + ',resizable';
    win = window.open(mypage, myname, winprops);
    if (parseInt(navigator.appVersion) >= 4) {
        win.window.focus();
    }
}

// Initial calc bind
function calc1() { updateTotals(); }