<?php
session_start();
require_once("connectioni.php");

if (!isset($_SESSION['company']) || $_SESSION['company'] == "") {
	exit("Please Login");
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Defective Good Received Note</title>
	<!-- Bootstrap 3.3.7 -->
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
	<!-- Font Awesome -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

	<style>
		body {
			background-color: #ecf0f5;
			font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
		}

		.navbar-custom {
			background-color: #2c3e50;
			color: white;
			padding: 10px 20px;
			display: flex;
			justify-content: space-between;
			align-items: center;
			margin-bottom: 20px;
		}

		.navbar-brand {
			font-size: 24px;
			font-weight: bold;
			color: white !important;
			padding: 0;
		}

		.page-title-box {
			background: rgba(255, 255, 255, 0.1);
			padding: 8px 30px;
			border-radius: 5px;
			font-size: 18px;
			font-weight: 600;
			text-transform: uppercase;
		}

		.box {
			background: #fff;
			border-top: 3px solid #d2d6de;
			box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
			margin-bottom: 20px;
			border-radius: 3px;
		}

		.box.box-primary {
			border-top-color: #3c8dbc;
		}

		.box-header {
			color: #444;
			border-bottom: 1px solid #f4f4f4;
			padding: 10px;
		}

		.box-body {
			padding: 20px;
		}
	</style>
	<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
	<script src="js/defective_item_gin.js"></script>
</head>

<body class="hold-transition skin-blue layout-top-nav">

	<!-- Navbar -->
	<div class="navbar-custom">
		<div class="navbar-brand">ERP SYSTEM MENU</div>
		<div class="page-title-box">DEFECTIVE GOOD RECEIVED NOTE (GIN)</div>
		<div class="user-info">
			[<?php echo isset($_SESSION['company']) ? $_SESSION['company'] : ''; ?>]
			<a href="logout.php" class="btn btn-danger btn-xs">Logout</a>
		</div>
	</div>

	<!-- Content -->
	<div class="container-fluid">
		<section class="content">

			<!-- Toolbar -->
			<div class="box box-solid">
				<div class="box-body">
					<button onclick="new_inv()" class="btn btn-default"><i class="fa fa-file"></i> New</button>
					<?php
					$user = $_SESSION['UserName'];
					// Permission check logic
					$sql = "select * from view_userpermission where username='" . $user . "' and docname='Defective Items' and grp='Data Capture'";
					// Assuming permission name is same or similar
					$result = mysqli_query($GLOBALS['dbinv'], $sql);
					if ($row_rs = mysqli_fetch_array($result)) {
						if ($row_rs["doc_feed"] == "1") {
							echo '<button onclick="save_inv()" class="btn btn-success"><i class="fa fa-save"></i> Save</button>';
						}
						if ($row_rs["doc_cancel"] == "1") {
							echo '<button onclick="cancel_inv()" class="btn btn-warning"><i class="fa fa-ban"></i> Cancel</button>';
						}
						if ($row_rs["doc_print"] == "1") {
							echo '<button onclick="print_inv()" class="btn btn-default"><i class="fa fa-print"></i> Print</button>';
						}
					}
					?>

					<button onclick="window.close()" class="btn btn-danger"><i class="fa fa-times"></i> Close</button>
					<a onclick="NewWindow('defective_item_gin_search.php?stname=DGRN', 'mywin', '800', '700', 'yes');"
						class="btn btn-info pull-right"><i class="fa fa-search"></i> Search DGRN</a>
				</div>
			</div>

			<div class="row">
				<!-- Header Info -->
				<div class="col-md-12">
					<div class="box box-primary">
						<div class="box-header with-border">
							<h3 class="box-title">General Details</h3>
						</div>
						<div class="box-body">
							<div class="row">
								<div class="col-md-3">
									<div class="form-group">
										<label>Ref No</label>
										<input type="text" id="txtrefno" class="form-control" disabled
											placeholder="Auto">
									</div>
								</div>
								<div class="col-md-3">
									<div class="form-group">
										<label>Date</label>
										<input type="date" id="dtdate" class="form-control"
											value="<?php echo date("Y-m-d"); ?>">
									</div>
								</div>
								<div class="col-md-3">
									<div class="form-group">
										<label>Department</label>
										<select id="com_dep" class="form-control">
											<?php
											$sql = "select * from s_stomas where act='1' order by CODE";
											$result = mysqli_query($GLOBALS['dbinv'], $sql);
											while ($row = mysqli_fetch_array($result)) {
												echo "<option value='" . $row["CODE"] . "'>" . $row["CODE"] . " " . $row["DESCRIPTION"] . "</option>";
											}
											?>
										</select>
									</div>
								</div>
								<div class="col-md-3">
									<div class="form-group">
										<label>Sales Rep</label>
										<select id="Com_rep" class="form-control">
											<?php
											$sql = "select * from s_salrep where pactive='1' order by REPCODE";
											$result = mysqli_query($GLOBALS['dbinv'], $sql);
											while ($row = mysqli_fetch_array($result)) {
												echo "<option value='" . $row["REPCODE"] . "'>" . $row["REPCODE"] . " " . $row["Name"] . "</option>";
											}
											?>
										</select>
									</div>
								</div>
							</div>

							<div class="row">
								<div class="col-md-3">
									<div class="form-group">
										<label>Claim No</label>
										<div class="input-group">
											<input type="text" id="txtcl_no" class="form-control"
												placeholder="Select Claim">
											<span class="input-group-btn">
												<button class="btn btn-default"
													onclick="NewWindow('defective_item_gin_claim_search.php?stname=DGRN', 'mywin', '800', '700', 'yes')"><i
														class="fa fa-search"></i></button>
											</span>
										</div>
									</div>
								</div>

								<div class="col-md-2">
									<div class="form-group">
										<label>Customer Code</label>
										<input type="text" id="txt_cuscode" class="form-control" disabled>
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label>Customer Name</label>
										<input type="text" id="txt_cusname" class="form-control" disabled>
									</div>
								</div>
								<div class="col-md-3">
									<div class="form-group">
										<label>Battery No</label>
										<input type="text" id="txtbat" class="form-control" disabled>
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-md-12">
									<div class="form-group">
										<label>Address</label>
										<input type="text" id="txtadd" class="form-control" disabled>
									</div>
								</div>
							</div>

							<div class="row">
								<div class="col-md-4">
									<div class="form-group">
										<label>Remarks</label>
										<textarea id="txtremark" class="form-control" rows="2"></textarea>
									</div>
								</div>
								<div class="col-md-2">
									<div class="form-group">
										<label>Defect Status</label>
										<select id="Cmbres" class="form-control">
											<option value=""></option>
											<option value="NO DEFECT">NO DEFECT</option>
											<option value="DEFECT">DEFECT</option>
											<option value="CUSTOMER MIS USED">CUSTOMER MIS USED</option>
											<option value="COMMERCIAL CLAIM">COMMERCIAL CLAIM</option>
										</select>
									</div>
								</div>
								<div class="col-md-3">
									<div class="form-group">
										<label>Shipment</label>
										<select id="cmbShip" class="form-control">
											<?php
											$sql = "select REFNO from s_purmas where CANCEL=0 and TYPE='Import'";
											$result = mysqli_query($GLOBALS['dbinv'], $sql);
											while ($row = mysqli_fetch_array($result)) {
												echo "<option value='" . $row["REFNO"] . "'>" . $row["REFNO"] . "</option>";
											}
											?>
										</select>
									</div>
								</div>
								<div class="col-md-3">
									<div class="form-group">
										<label>Invoice No</label>
										<input type="text" id="refInv" class="form-control">
									</div>
								</div>
							</div>

						</div>
					</div>
				</div>
			</div>

			<div class="row">
				<div class="col-md-12">
					<div class="box box-info">
						<div class="box-header with-border">
							<h3 class="box-title">Item Details</h3>
						</div>
						<div class="box-body">
							<div class="row">
								<div class="col-md-2">
									<div class="form-group">
										<label>Item</label>
										<div class="input-group">
											<input type="text" id="itemno" class="form-control" placeholder="Code">
											<span class="input-group-btn">
												<button class="btn btn-default"
													onclick="NewWindow('serach_item.php', 'mywin', '800', '700', 'yes')"><i
														class="fa fa-search"></i></button>
											</span>
										</div>
									</div>
								</div>
								<div class="col-md-3">
									<div class="form-group">
										<label>Description</label>
										<input type="text" id="item_name" class="form-control" disabled>
									</div>
								</div>
								<div class="col-md-1">
									<div class="form-group">
										<label>Part No</label>
										<input type="text" id="partno" class="form-control" disabled>
									</div>
								</div>
								<div class="col-md-1">
									<div class="form-group">
										<label>Rate</label>
										<input type="text" id="rate" class="form-control">
									</div>
								</div>
								<div class="col-md-1">
									<div class="form-group">
										<label>Qty</label>
										<input type="text" id="qty" class="form-control">
									</div>
								</div>
								<div class="col-md-1">
									<div class="form-group">
										<label>Disc %</label>
										<input type="text" id="discou" class="form-control">
									</div>
								</div>
								<div class="col-md-1">
									<div class="form-group">
										<label>Sub</label>
										<input type="text" id="subtot" class="form-control" disabled>
									</div>
								</div>
								<div class="col-md-1">
									<div class="form-group">
										<label>Total</label>
										<input type="text" id="total" class="form-control" disabled>
									</div>
								</div>
								<div class="col-md-1">
									<div class="form-group">
										<label>&nbsp;</label>
										<button onclick="add_tmp()" class="btn btn-primary btn-block"><i
												class="fa fa-plus"></i></button>
									</div>
								</div>
							</div>

							<hr>
							<div id="itemdetails"></div>

							<div class="row">
								<div class="col-md-9 text-right">
									<h4>Total Amount</h4>
								</div>
								<div class="col-md-3">
									<input type="text" id="txt_net" class="form-control input-lg text-right" disabled>
								</div>
							</div>

						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</body>

</html>