<?php
session_start();
require_once("connectioni.php");

header('Content-Type: application/json');

$command = isset($_GET['Command']) ? $_GET['Command'] : (isset($_POST['Command']) ? $_POST['Command'] : '');

if ($command == "new_inv") {
    $company = $_SESSION['company'];

    // Get Ref No from invpara or similar. Using a generic sequence or similar logic to sales_inv_data
    // Assuming 'invpara' table has a counter for this document type. 
    // If not, we might defaults or a specific column. 
    // Checking sales_inv_data.php, they use 'SPINV2' etc. defined by 'flag'.

    // For Safety, let's use a simpler generation or assume a column 'DGRN' in invpara if it exists, or just count.

    // Mocking generation based on Date for now if invpara column unknown, 
    // but better to try to find a sequence.

    // Let's assume a standard sequence mechanism.
    $sql = "SELECT DGRN FROM invpara WHERE flag = '$company'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    $newRef = "";
    if ($row = mysqli_fetch_assoc($result)) {
        $newRef = "DGRN/" . $company . "/" . str_pad($row['DGRN'], 6, "0", STR_PAD_LEFT);
    } else {
        // Fallback? or maybe the column is different.
        $newRef = "DGRN/" . $company . "/" . date("ymdHis");
    }

    echo json_encode([
        'status' => 'success',
        'refno' => $newRef,
        'date' => date('Y-m-d')
    ]);
    exit();
}

if ($command == "save_item") {
    try {
        $GLOBALS['dbinv']->begin_transaction();

        $refno = $_POST['txtrefno'];
        $sdate = $_POST['dtdate'];
        $cus_code = $_POST['txt_cuscode'];
        $cus_name = $_POST['txt_cusname'];
        $amount = $_POST['txt_net'];
        $remarks = $_POST['txtremark'];
        $department = $_POST['com_dep'];
        $sales_rep = $_POST['Com_rep'];

        $claim_no = $_POST['txtcl_no'];
        $defect_reason = $_POST['Cmbres'];

        $items = json_decode($_POST['items'], true);

        // 1. Insert Header
        // Need to know columns of s_deftrn. 
        // Based on previous search: REFNO, BAT_NO, CLAM_NO, SDATE, CANCELL, company
        // adding common ones: CUS_CODE, CUS_NAME, AMOUNT, DEPARTMENT, SAL_EX (Rep), REMARKS

        $sqlHead = "INSERT INTO s_deftrn (REFNO, SDATE, CUS_CODE, CUS_NAME, AMOUNT, DEPARTMENT, SAL_EX, REMARKS, CLAM_NO, DEF_REASON, CANCELL, company, USER) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, '0', ?, ?)";

        $stmt = $GLOBALS['dbinv']->prepare($sqlHead);
        $company = $_SESSION['company'];
        $user = $_SESSION['CurrentUser']; // or UserName
        $stmt->bind_param("ssssssssssss", $refno, $sdate, $cus_code, $cus_name, $amount, $department, $sales_rep, $remarks, $claim_no, $defect_reason, $company, $user);
        $stmt->execute();

        // 2. Insert Details
        // Table: s_deftrn_itm (Assumed)
        // Columns: REFNO, STK_NO, DESCRIPT, QTY, RATE, SUBTOTAL

        // Setup stmt for items
        $sqlItem = "INSERT INTO s_deftrn_itm (REFNO, STK_NO, DESCRIPT, QTY, RATE, SUBTOTAL) VALUES (?, ?, ?, ?, ?, ?)";
        $stmtItem = $GLOBALS['dbinv']->prepare($sqlItem);

        foreach ($items as $item) {
            $stmtItem->bind_param("ssssss", $refno, $item['itemCode'], $item['itemName'], $item['qty'], $item['rate'], $item['total']);
            $stmtItem->execute();
        }

        // Update Sequence
        $sqlSeq = "UPDATE invpara SET DGRN = DGRN + 1 WHERE flag = '$company'";
        mysqli_query($GLOBALS['dbinv'], $sqlSeq);

        $GLOBALS['dbinv']->commit();
        echo json_encode(['status' => 'success', 'message' => 'Saved Successfully']);

    } catch (Exception $e) {
        $GLOBALS['dbinv']->rollback();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit();
}

if ($command == "get_item") {
    $itemCode = $_GET['itemCode'];
    // Fetch from s_mas
    $sql = "SELECT STK_NO, DESCRIPT, SELLING, COST FROM s_mas WHERE STK_NO = '$itemCode'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if ($row = mysqli_fetch_assoc($result)) {
        echo json_encode(['status' => 'success', 'data' => $row]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Item not found']);
    }
    exit();
}

if ($command == "load_claim") {
    // Load details from c_clamas based on Claim Ref
    $refno = $_GET['refno'];
    $sql = "SELECT * FROM c_clamas WHERE refno = '$refno'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    if ($row = mysqli_fetch_assoc($result)) {
        // Also need to fetch items for this claim? 
        // Or does the user add them manually? The legacy code used 'search_item' likely.
        // But if it's based on a claim, maybe we pre-fill?
        // Legacy `defect` function fills `txt_cuscode`, `txt_cusname`, `txtbat`, `itemno` etc.
        // It seems the claim has item info too.
        echo json_encode(['status' => 'success', 'data' => $row]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Claim not found']);
    }
    exit();
}
?>