<?php
session_start();
require_once("connection_sql.php");
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_POST['Command']) ? $_POST['Command'] : (isset($_GET['Command']) ? $_GET['Command'] : '');

if ($command == "get_departments") {
    try {
        $sql = "select * from s_stomas where act='1' order by CODE";
        $result = $conn->query($sql);
        $data = [];
        foreach ($result as $row) {
            $data[] = [
                'code' => $row['CODE'],
                'description' => $row['DESCRIPTION']
            ];
        }
        echo json_encode(['status' => 'success', 'data' => $data]);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "search_items") {
    try {
        $from_dep = $_GET['from_dep'] ?? '';
        $query = $_GET['query'] ?? '';

        // Minimal search: Job No or Serial No or Ref No
        // Filter by From Dept if provided (assuming 'onhand' in that dept or similar logic)
        // Adjusting query to search flexible fields

        // Logic: Search in dag_item where cancel=0
        // If a department filter is strictly required by business logic, we'd add it.
        // For now, assuming Global Search or filtered by current location if 'department' column exists.
        // Legacy code didn't seem to enforce strict DB filtering by dept in the 'search_item' function,
        // but it's good practice. I'll stick to a broad search for now as the 'department' column on dag_item isn't confirmed.
        // Actually, the plan says "Update dag_item set department...". So `dag_item` likely has `department`.

        $sql = "SELECT * FROM dag_item WHERE cancel='0' ";

        /* 
        // If we want to enforce filtering by current department:
        if (!empty($from_dep)) {
             $sql .= " AND department = '$from_dep' ";
        }
        */

        if (!empty($query)) {
            $sql .= " AND (jobno LIKE '%$query%' OR serialno LIKE '%$query%' OR refno LIKE '%$query%') ";
        }

        $sql .= " LIMIT 20";

        $result = $conn->query($sql);
        $data = [];
        foreach ($result as $row) {
            $data[] = [
                'jobno' => $row['jobno'],
                'refno' => $row['refno'],
                'serialno' => $row['serialno'],
                'marker' => $row['marker'],     // Make
                'size' => $row['size'],
                'cascost' => $row['cascost'],   // Rate/Cost
                'cusname' => $row['cusname'],
                'department' => $row['department'] ?? '' // Current Dept
            ];
        }
        echo json_encode(['status' => 'success', 'data' => $data]);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "get_item_details") {
    try {
        $jobno = $_GET['jobno'] ?? '';
        $serialno = $_GET['serialno'] ?? '';

        $sql = "SELECT * FROM dag_item WHERE cancel='0' AND (jobno = '$jobno' OR serialno = '$serialno') LIMIT 1";
        $result = $conn->query($sql);
        $row = $result->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            echo json_encode([
                'status' => 'success',
                'data' => [
                    'jobno' => $row['jobno'],
                    'refno' => $row['refno'], // Stk/Ref No
                    'serialno' => $row['serialno'],
                    'marker' => $row['marker'],
                    'size' => $row['size'],
                    'cascost' => $row['cascost'],
                    'department' => $row['department']
                ]
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Item not found']);
        }
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "save_transfer") {
    try {
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $conn->beginTransaction();

        $input = json_decode(file_get_contents('php://input'), true);

        $sdate = $input['sdate'];
        $from_dep = $input['from_dep'];
        $to_dep = $input['to_dep'];
        $items = $input['items']; // Array of {jobno, serialno, ...}

        if (empty($items)) {
            throw new Exception("No items to transfer.");
        }

        if ($from_dep == $to_dep) {
            throw new Exception("From and To Departments cannot be the same.");
        }

        // 1. Generate Header Reference (ST No / GIN No)
        // Using uniqid or a sequence logic. For consistency with legacy, usually it's a generated ID.
        // I will use a simple "DAG-TRN-" . time() or retrieve last ID logic if available.
        // Legacy used `get_ref('invno')`. I'll simulate a unique ID for now.
        $ref_no = "ST/" . date("ym") . "/" . rand(1000, 9999);

        // 2. Insert Header (s_ginmas)
        // Assuming fields based on typical structure + legacy search query
        $sqlHeader = "INSERT INTO s_ginmas (REF_NO, SDATE, DEP_FROM, DEP_TO, TYPE, cancel, flag, company) 
                      VALUES (?, ?, ?, ?, 'DAG TRANSFER', '0', '0', ?)";

        // Need to fetch Dept Names for saving names? Legacy saved names...
        // Fetch Names
        $stmtDep = $conn->prepare("SELECT DESCRIPTION FROM s_stomas WHERE CODE = ?");
        $stmtDep->execute([$from_dep]);
        $from_desc = $stmtDep->fetchColumn();
        $stmtDep->execute([$to_dep]);
        $to_desc = $stmtDep->fetchColumn();

        // Actually the legacy table has DEP_F_NAME, DEP_T_NAME columns likely.
        // Let's retry insert with assumed valid columns from legacy search.
        // Legacy Search: REF_NO, DEP_F_NAME, DEP_T_NAME, SDATE, tmp_no (used as ID?)

        $sqlHeader = "INSERT INTO s_ginmas (REF_NO, SDATE, DEP_FROM, DEP_TO, DEP_F_NAME, DEP_T_NAME, TYPE, cancel, company, tmp_no) 
                      VALUES (?, ?, ?, ?, ?, ?, 'DAG TRANSFER', '0', ?, ?)";

        // Using ref_no as tmp_no for linking purposes or generate a separate uniqid
        $tmp_no = uniqid();

        $conn->prepare($sqlHeader)->execute([$ref_no, $sdate, $from_dep, $to_dep, $from_desc, $to_desc, $_SESSION['company'] ?? '', $tmp_no]);

        // 3. Process Items
        $sqlItemUpdate = "UPDATE dag_item SET department = ? WHERE jobno = ? AND serialno = ?";
        $sqlDetailInsert = "INSERT INTO s_gintrn (REF_NO, SDATE, STK_NO, DESCRIPT, QTY, JOB_NO, BRAND, c_code) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        // c_code used for serial? legacy vague. Mapping best effort.

        $stmtUpdate = $conn->prepare($sqlItemUpdate);
        $stmtDetail = $conn->prepare($sqlDetailInsert);

        foreach ($items as $item) {
            $jobno = $item['jobno'];
            $serialno = $item['serialno'];
            $make = $item['make']; // Brand
            $refno = $item['refno']; // STK_NO/Item Code

            // Update Department
            $stmtUpdate->execute([$to_dep, $jobno, $serialno]);

            // Insert Detail
            $stmtDetail->execute([$ref_no, $sdate, $refno, "", 1, $jobno, $make, $serialno]);

            // Log
            $logMsg = "Transfer Item $jobno ($serialno) from $from_desc to $to_desc";
            $conn->query("INSERT INTO entry_log(refno, username, docname, trnType, stime, sdate) values ('$ref_no', '" . $_SESSION["CURRENT_USER"] . "', '$logMsg', 'Transfer', '" . date("Y-m-d H:i:s") . "', '" . date("Y-m-d") . "')");
        }

        $conn->commit();
        echo json_encode(['status' => 'success', 'message' => 'Transfer Saved Successfully', 'ref_no' => $ref_no]);

    } catch (Exception $e) {
        $conn->rollBack();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}
?>