<?php
session_start();
require_once("connection_sql.php");
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_POST['Command']) ? $_POST['Command'] : (isset($_GET['Command']) ? $_GET['Command'] : '');

if ($command == "get_initial_data") {
    $data = [];

    // Departments
    $sql = "select * from s_stomas where act='1' order by CODE";
    $res = $conn->query($sql);
    $depts = [];
    foreach ($res as $row) {
        $depts[] = ['code' => $row['CODE'], 'description' => $row['DESCRIPTION']];
    }
    $data['departments'] = $depts;

    // Sizes
    $sql = "Select * from dag_size order by name asc";
    $res = $conn->query($sql);
    $sizes = [];
    foreach ($res as $row) {
        $sizes[] = ['name' => $row['name']];
    }
    $data['sizes'] = $sizes;

    // Markers (Make)
    $sql = "Select * from dag_marker order by name asc";
    $res = $conn->query($sql);
    $markers = [];
    foreach ($res as $row) {
        $markers[] = ['name' => $row['name']];
    }
    $data['markers'] = $markers;

    // Belts
    $sql = "Select * from dag_belt order by code";
    $res = $conn->query($sql);
    $belts = [];
    foreach ($res as $row) {
        $belts[] = ['name' => $row['name']];
    }
    $data['belts'] = $belts;

    echo json_encode(['status' => 'success', 'data' => $data]);
    exit;
}

if ($command == "get_new_refno") {
    // Generate Ref No
    // Legacy logic: select refno from dag order by id desc limit 1
    // Usually DAG/XXXXXX
    $refno = "DAG/" . date("ym") . "/" . rand(1000, 9999);
    // Ideally we should use a sequential number from parameters, but sticking to unique generation for safety in this refactor unless sequence table exists.
    // Legacy `dag_data.php` tried to increment.

    echo json_encode(['status' => 'success', 'refno' => $refno, 'sdate' => date('Y-m-d')]);
    exit;
}

if ($command == "save_purchase") {
    try {
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $conn->beginTransaction();

        $input = json_decode(file_get_contents('php://input'), true);

        $refno = $input['refno'];
        $sdate = $input['sdate'] ?? date('Y-m-d');
        $department = $input['department'];
        $cuscode = $input['cuscode'];
        $cusname = $input['cusname'];
        $invno = $input['invno'];
        $invdate = $input['invdate'];
        $items = $input['items'];
        $vatGroup = $input['vat_group']; // 0=Non VAT, 1=VAT, 2=SVAT (mapped from frontend)

        // Calculate Totals
        $subtot = 0;
        foreach ($items as $item) {
            // Assuming cost * qty? Legacy didn't have Qty column in `dag_item` explicitly shown in table config but usually implied 1 per serial?
            // `dag_item` has: jobno, serialno, ... cost.
            // We'll assume qty=1 per row.
            $subtot += (float) $item['cascost'];
        }

        $tax = 0;
        if ($vatGroup == '1') { // VAT
            $tax = $subtot * 0.15; // Example rate, or fetch from params
            // Legacy didn't show calculation logic, simplified here.
        }
        $gtot = $subtot + $tax;

        // Message to allow saving existing REFNO (Update) or New
        // For Update, delete existing items and re-insert? Or Update?
        // Let's assume Insert for 'New' and Update for 'Edit'.
        // RefNo check:
        $stmt = $conn->prepare("SELECT count(*) FROM dag WHERE refno = ?");
        $stmt->execute([$refno]);
        $exists = $stmt->fetchColumn() > 0;

        if ($exists) {
            // Update Header
            $sqlHead = "UPDATE dag SET sdate=?, cuscode=?, cusname=?, department=?, invno=?, cascost=?, adpayment=? WHERE refno=?";
            // adpayment? Legacy has it field.
            $conn->prepare($sqlHead)->execute([$sdate, $cuscode, $cusname, $department, $invno, $subtot, 0, $refno]);

            // Delete existing items to replace
            $conn->prepare("DELETE FROM dag_item WHERE refno = ?")->execute([$refno]);
        } else {
            $sqlHead = "INSERT INTO dag (refno, sdate, cuscode, cusname, department, invno, cascost, adpayment, company, cancel) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, '0')";
            $conn->prepare($sqlHead)->execute([$refno, $sdate, $cuscode, $cusname, $department, $invno, $subtot, 0, $_SESSION['company']]);
        }

        // Insert Items
        $sqlItem = "INSERT INTO dag_item (refno, jobno, serialno, cuscode, cusname, marker, size, belt, warrenty, remark, cost, uniq, flag, cancel, company, department, type) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, '1', '0', ?, ?, ?)";
        $stmtItem = $conn->prepare($sqlItem);

        foreach ($items as $item) {
            $uniq = uniqid();
            $stmtItem->execute([
                $refno,
                $item['jobno'],
                $item['serialno'],
                $cuscode,
                $cusname,
                $item['marker'],
                $item['size'],
                $item['belt'],
                $item['warranty'],
                $item['remark'],
                $item['cascost'],
                $uniq,
                $_SESSION['company'],
                $department,
                $item['dagtype']
            ]);
        }

        // Log?

        $conn->commit();
        echo json_encode(['status' => 'success', 'message' => 'Saved Successfully', 'refno' => $refno]);

    } catch (Exception $e) {
        $conn->rollBack();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "search_purchase") {
    $refno = $_GET['refno'];
    // Load Header
    $stmt = $conn->prepare("SELECT * FROM dag WHERE refno = ?");
    $stmt->execute([$refno]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        // Load Items
        $stmtItems = $conn->prepare("SELECT * FROM dag_item WHERE refno = ? AND cancel='0'");
        $stmtItems->execute([$refno]);
        $items = $stmtItems->fetchAll(PDO::FETCH_ASSOC);

        // Map Item fields
        $mappedItems = [];
        foreach ($items as $i) {
            $mappedItems[] = [
                'jobno' => $i['jobno'],
                'serialno' => $i['serialno'],
                'marker' => $i['marker'],
                'size' => $i['size'],
                'belt' => $i['belt'],
                'warranty' => $i['warrenty'], // note spelling
                'remark' => $i['remark'],
                'cascost' => $i['cost'],
                'dagtype' => $i['type'] ?? ''
            ];
        }

        echo json_encode([
            'status' => 'success',
            'data' => [
                'header' => $row,
                'items' => $mappedItems
            ]
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Not Found']);
    }
    exit;
}

if ($command == "get_next_jobno") {
    // Legacy "setjobno" logic
    echo json_encode(['status' => 'success', 'jobno' => 'JOB-' . uniqid()]);
    exit;
}
?>