<?php
session_start();
require_once("connectioni.php");

if (!isset($_SESSION['company']) || $_SESSION['company'] == "") {
    exit("Please Login");
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DAG Direct Purchase</title>

    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }

        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }

        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            padding: 0;
            line-height: normal;
        }

        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            text-transform: uppercase;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .logout-btn {
            background-color: #e74c3c;
            color: white;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            text-decoration: none !important;
        }

        .content-wrapper {
            padding: 20px;
        }

        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
            border-radius: 3px;
        }

        .box.box-primary {
            border-top-color: #3c8dbc;
        }

        .box-header {
            color: #444;
            border-bottom: 1px solid #f4f4f4;
            padding: 10px;
        }

        .box-body {
            padding: 20px;
        }

        .form-control {
            border-radius: 0;
            border-color: #d2d6de;
        }

        .btn {
            border-radius: 3px;
        }
    </style>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

    <script src="js/dag_purchase.js"></script>
</head>

<body class="hold-transition skin-blue layout-top-nav">

    <!-- Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        <div class="page-title-box">DAG DIRECT PURCHASE</div>
        <div class="user-info">
            <span>Welcome, <span
                    class="user-name"><?php echo isset($_SESSION['CURRENT_USER']) ? $_SESSION['CURRENT_USER'] : 'User'; ?></span>
                [<?php echo isset($_SESSION['company']) ? $_SESSION['company'] : ''; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

    <!-- Content -->
    <div class="content-wrapper">
        <section class="content">

            <!-- Toolbar -->
            <div class="box box-solid">
                <div class="box-body">
                    <button onclick="new_inv()" class="btn btn-default"><i class="fa fa-file"></i> New</button>
                    <button onclick="save_inv()" class="btn btn-success"><i class="fa fa-save"></i> Save</button>
                    <button onclick="cancel_inv()" class="btn btn-danger"><i class="fa fa-times"></i> Cancel</button>
                    <button onclick="print_inv()" class="btn btn-default"><i class="fa fa-print"></i> Print</button>
                    <a onclick="NewWindow('dag_search.php', 'mywin', '800', '700', 'yes', 'center');"
                        class="btn btn-info"><i class="fa fa-search"></i> Find</a>
                </div>
            </div>

            <!-- Main Form -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Purchase Details</h3>
                </div>
                <div class="box-body">

                    <!-- Header Row 1 -->
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Ref No</label>
                                <input type="text" id="refno" class="form-control" placeholder="Auto Generated"
                                    disabled>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Department</label>
                                <select id="department" class="form-control" onchange="setjobno()"></select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>VAT Group</label>
                                <div>
                                    <label class="radio-inline"><input type="radio" name="vatgroup" id="vatgroup_0"
                                            onclick="updateTotals()"> VAT</label>
                                    <label class="radio-inline"><input type="radio" name="vatgroup" id="vatgroup_1"
                                            checked onclick="updateTotals()"> Non VAT</label>
                                    <label class="radio-inline"><input type="radio" name="vatgroup" id="vatgroup_2"
                                            onclick="updateTotals()"> SVAT</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Date</label>
                                <input type="date" id="sdate" class="form-control" value="<?php echo date('Y-m-d'); ?>">
                            </div>
                        </div>
                    </div>

                    <!-- Header Row 2 -->
                    <div class="row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Supplier Code</label>
                                <input type="text" id="cuscode" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Supplier Name</label>
                                <div class="input-group">
                                    <input type="text" id="cusname" class="form-control" disabled>
                                    <span class="input-group-btn">
                                        <button class="btn btn-default"
                                            onclick="NewWindow('customer_search.php?stname=dag', 'mywin', '800', '700', 'yes', 'center')"><i
                                                class="fa fa-search"></i></button>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Invoice No</label>
                                <input type="text" id="invno" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Invoice Date</label>
                                <input type="date" id="invdate" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-2 hidden">
                            <div class="form-group">
                                <label>Adv Payment</label>
                                <input type="number" id="adpayment" class="form-control" disabled>
                            </div>
                        </div>
                    </div>

                    <hr>

                    <!-- Details Input -->
                    <div class="row bg-info" style="padding-top: 10px; padding-bottom: 10px; margin: 0;">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Type</label>
                                <select id="dagtype" class="form-control">
                                    <option value="">Select</option>
                                    <option value="BIAS">BIAS</option>
                                    <option value="RADIAL">RADIAL</option>
                                    <option value="DAG CUST">DAG CUST</option>
                                    <option value="DAG SALE">DAG SALE</option>
                                    <option value="R/B CUST">R/B CUST</option>
                                    <option value="R/B SALE">R/B SALE</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Size</label>
                                <select id="size" class="form-control"></select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Make</label>
                                <select id="marker" class="form-control"></select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Belt Design</label>
                                <select id="belt" class="form-control"></select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Cost</label>
                                <input type="number" id="cascost" class="form-control" placeholder="0.00">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Selling Price</label>
                                <input type="number" id="selling" class="form-control" placeholder="0.00">
                            </div>
                        </div>
                    </div>

                    <div class="row bg-info" style="padding-bottom: 10px; margin: 0; margin-bottom: 15px;">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Job No</label>
                                <input type="text" id="jobno" class="form-control" placeholder="JOB-XXXX">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Serial No</label>
                                <input type="text" id="serialno" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Warranty</label>
                                <select id="warranty" class="form-control">
                                    <option value="YES">YES</option>
                                    <option value="NO">NO</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Remark</label>
                                <div class="input-group">
                                    <input type="text" id="remark" class="form-control">
                                    <span class="input-group-btn">
                                        <button class="btn btn-warning"
                                            onclick="NewWindow('dag_purchase_dag_search.php?stname=dag', 'mywin', '800', '700', 'yes', 'center')"><i
                                                class="fa fa-search"></i></button>
                                        <button class="btn btn-success" onclick="add_tmp()"><i class="fa fa-plus"></i>
                                            Add</button>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Item List -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Job No</th>
                                    <th>Serial No</th>
                                    <th>Type</th>
                                    <th>Size</th>
                                    <th>Make</th>
                                    <th>Belt</th>
                                    <th>Cost</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="item_list_body">
                                <tr>
                                    <td colspan="8" class="text-center text-muted">No items added</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- Footer Totals -->
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-8"></div>
                        <div class="col-md-4">
                            <div class="form-horizontal">
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Sub Total</label>
                                    <div class="col-sm-8">
                                        <input type="text" id="subtot" class="form-control text-right" disabled
                                            value="0.00">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Tax</label>
                                    <div class="col-sm-8">
                                        <input type="text" id="tax" class="form-control text-right" disabled
                                            value="0.00">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Grand Total</label>
                                    <div class="col-sm-8">
                                        <input type="text" id="gtot" class="form-control text-right"
                                            style="font-weight: bold; font-size: 16px;" disabled value="0.00">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </section>
    </div>

    <!-- Hidden Uniq for compatibility if needed -->
    <input type="hidden" id="uniq">

    <script>
        document.addEventListener('keydown', function (event) {
            if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
                event.preventDefault();
                window.location.href = 'logout.php';
            }
        });
    </script>
</body>

</html>