<?php
session_start();
require_once("connectioni.php"); // Using global connection
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create DAG</title>

    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <style>
        body {
            background-color: #ecf0f5;
            /* Light grey background for ERP feel */
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }

        /* Navbar Styles */
        .navbar-custom {
            background-color: #2c3e50;
            /* Primary Color */
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }

        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }

        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .logout-btn {
            background-color: #e74c3c;
            /* Danger Color */
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }

        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }

        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }

        /* Box/Card Styling */
        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
            border-radius: 3px;
        }

        .box.box-primary {
            border-top-color: #3c8dbc;
        }

        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
        }

        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
        }

        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }

        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }

        /* Buttons */
        .btn-app {
            color: #444;
            background: #f4f4f4;
            border: 1px solid #ddd;
            padding: 12px 5px;
            height: 60px;
            min-width: 80px;
            margin: 0 5px 5px 0;
        }

        .btn-app:hover {
            background: #e7e7e7;
        }

        /* Utility */
        .hidden {
            display: none;
        }
    </style>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
    <script src="js/dag.js"></script>

    <!-- Popup Window Script -->
    <script language="javascript" type="text/javascript">
        var win = null;
        function NewWindow(mypage, myname, w, h, scroll, pos) {
            if (pos == "random") { LeftPosition = (screen.width) ? Math.floor(Math.random() * (screen.width - w)) : 100; TopPosition = (screen.height) ? Math.floor(Math.random() * ((screen.height - h) - 75)) : 100; }
            if (pos == "center") { LeftPosition = (screen.width) ? (screen.width - w) / 2 : 100; TopPosition = (screen.height) ? (screen.height - h) / 2 : 100; }
            else if ((pos != "center" && pos != "random") || pos == null) { LeftPosition = 0; TopPosition = 20 }
            settings = 'width=' + w + ',height=' + h + ',top=' + TopPosition + ',left=' + LeftPosition + ',scrollbars=' + scroll + ',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
            win = window.open(mypage, myname, settings);
        }
    </script>
</head>

<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>

        <div class="page-title-box">
            Create DAG
        </div>

        <div class="user-info">
            <span>Welcome, <span
                    class="user-name"><?php echo isset($_SESSION['CURRENT_USER']) ? $_SESSION['CURRENT_USER'] : 'User'; ?></span>
                [<?php echo isset($_SESSION['company']) ? $_SESSION['company'] : ''; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

    <div class="content-wrapper">
        <section class="content">

            <!-- Toolbar -->
            <div class="box box-solid">
                <div class="box-body">
                    <a onclick="new_inv()" class="btn btn-app"><i class="fa fa-file"></i> New</a>
                    <a onclick="save_inv()" class="btn btn-app"><i class="fa fa-save"></i> Save</a>
                    <a onclick="cancel_inv()" class="btn btn-app"><i class="fa fa-ban"></i> Cancel</a>
                    <a onclick="print_inv()" class="btn btn-app"><i class="fa fa-print"></i> Print</a>
                    <a onclick="NewWindow('dag_search.php', 'mywin', '800', '700', 'yes', 'center');"
                        class="btn btn-app"><i class="fa fa-search"></i> Find</a>
                    <a onclick="close_form()" class="btn btn-app"><i class="fa fa-close"></i> Close</a>
                </div>
            </div>

            <input type="hidden" id="uniq" class="form-control">

            <div class="row">
                <!-- Main Form -->
                <div class="col-md-12">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Order Details</h3>
                        </div>
                        <div class="box-body">
                            <form class="form-horizontal">

                                <!-- Top Row -->
                                <div class="form-group">
                                    <label class="col-sm-1 control-label">Ref No</label>
                                    <div class="col-sm-2">
                                        <input type="text" id="refno" class="form-control" readonly>
                                    </div>

                                    <label class="col-sm-1 control-label">Department</label>
                                    <div class="col-sm-2">
                                        <select id="department" onchange="setjobno();" class="form-control">
                                            <?php
                                            $sql = "select * from s_stomas where act='1' order by CODE";
                                            $result = mysqli_query($GLOBALS['dbinv'], $sql);
                                            while ($row = mysqli_fetch_array($result)) {
                                                echo "<option value=\"" . $row["CODE"] . "\">" . $row["DESCRIPTION"] . "</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>

                                    <label class="col-sm-1 control-label">Invoice No</label>
                                    <div class="col-sm-2">
                                        <input type="text" id="invno" class="form-control">
                                    </div>

                                    <label class="col-sm-1 control-label">Date</label>
                                    <div class="col-sm-2">
                                        <input type="date" id="sdate" value="<?php echo date('Y-m-d') ?>"
                                            class="form-control">
                                    </div>
                                </div>

                                <!-- Customer Row -->
                                <div class="form-group">
                                    <label class="col-sm-1 control-label">Customer</label>
                                    <div class="col-sm-2">
                                        <input type="text" id="cuscode" class="form-control" placeholder="Code"
                                            readonly>
                                    </div>
                                    <div class="col-sm-3">
                                        <input type="text" id="cusname" class="form-control" placeholder="Name"
                                            readonly>
                                    </div>
                                    <div class="col-sm-1">
                                        <a onclick="search_cust()" class="btn btn-default"><i
                                                class="fa fa-search"></i></a>
                                    </div>

                                    <label class="col-sm-1 control-label">Type</label>
                                    <div class="col-sm-2">
                                        <select id="dagtype" class="form-control">
                                            <option value=""></option>
                                            <option value="BIAS">BIAS</option>
                                            <option value="RADIAL">RADIAL</option>
                                            <option value="DAG CUST">DAG CUST</option>
                                            <option value="DAG SALE">DAG SALE</option>
                                            <option value="R/B CUST">R/B CUST</option>
                                            <option value="R/B SALE">R/B SALE</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-sm-1 control-label">Casing Cost</label>
                                    <div class="col-sm-2">
                                        <input type="number" id="cascost" class="form-control">
                                    </div>
                                    <label class="col-sm-1 control-label hidden">Advance</label>
                                    <div class="col-sm-2 hidden">
                                        <input type="number" id="adpayment" class="form-control" disabled>
                                    </div>
                                </div>

                                <hr>

                                <!-- Item Config Row -->
                                <div class="bg-info" style="padding: 10px; margin-bottom: 10px;">
                                    <div class="form-group" style="margin-bottom:0px;">
                                        <label class="col-sm-1 control-label">Job No</label>
                                        <div class="col-sm-2">
                                            <input type="text" id="jobno" class="form-control">
                                        </div>

                                        <label class="col-sm-1 control-label">Serial No</label>
                                        <div class="col-sm-2">
                                            <input type="text" id="serialno" class="form-control">
                                        </div>

                                        <label class="col-sm-1 control-label">Warranty</label>
                                        <div class="col-sm-2">
                                            <select id="warranty" class="form-control">
                                                <option value="YES">YES</option>
                                                <option value="NO">NO</option>
                                            </select>
                                        </div>

                                        <label class="col-sm-1 control-label">Make</label>
                                        <div class="col-sm-2">
                                            <select id="marker" class="form-control">
                                                <?php
                                                $sql = "Select * from dag_marker order by code";
                                                $result = mysqli_query($GLOBALS['dbinv'], $sql);
                                                while ($row = mysqli_fetch_array($result)) {
                                                    echo "<option value=\"" . $row["name"] . "\">" . $row["name"] . "</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group" style="margin-top:10px; margin-bottom:0px;">
                                        <label class="col-sm-1 control-label">Size</label>
                                        <div class="col-sm-2">
                                            <select id="size" class="form-control">
                                                <?php
                                                $sql = "Select * from dag_size order by code";
                                                $result = mysqli_query($GLOBALS['dbinv'], $sql);
                                                while ($row = mysqli_fetch_array($result)) {
                                                    echo "<option value=\"" . $row["name"] . "\">" . $row["name"] . "</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>

                                        <label class="col-sm-1 control-label">Belt</label>
                                        <div class="col-sm-2">
                                            <select id="belt" class="form-control">
                                                <?php
                                                $sql = "Select * from dag_belt order by code";
                                                $result = mysqli_query($GLOBALS['dbinv'], $sql);
                                                while ($row = mysqli_fetch_array($result)) {
                                                    echo "<option value=\"" . $row["name"] . "\">" . $row["name"] . "</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>

                                        <label class="col-sm-1 control-label">Remark</label>
                                        <div class="col-sm-3">
                                            <input type="text" id="remark" class="form-control">
                                        </div>

                                        <div class="col-sm-2">
                                            <a onclick="add_tmp()" class="btn btn-success btn-block"><i
                                                    class="fa fa-plus"></i> ADD ITEM</a>
                                        </div>
                                    </div>
                                </div>

                            </form>

                            <!-- Item Grid -->
                            <div id="itemdetails"></div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <script>
        // Keyboard Shortcut for Logout (Ctrl+Q)
        document.addEventListener('keydown', function (event) {
            if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
                event.preventDefault();
                window.location.href = 'logout.php';
            }
        });
    </script>
</body>

</html>