<?php
session_start();
require_once("connection_sql.php");
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_POST['Command']) ? $_POST['Command'] : (isset($_GET['Command']) ? $_GET['Command'] : '');

if ($command == "new_inv") {
    // Generate EXT No
    $refno = "EXT/" . date("ym") . "/" . rand(1000, 9999);

    echo json_encode([
        'status' => 'success',
        'refno' => $refno,
        'date' => date('Y-m-d'),
        'time' => date('H:i:s')
    ]);
    exit;
}

if ($command == "save_item") {
    try {
        $refno = $_POST['txtrefno'];
        $chk_no = $_POST['txtch_no'];
        $chk_date = $_POST['txtch_date'];
        $extend_date = $_POST['txtchexdate'];
        $amount = $_POST['txtch_amount'];
        $cuscode = $_POST['txtcode'];
        $cusname = $_POST['txtname'];
        $salesrep = $_POST['txtsal_ex'];
        $deduct = $_POST['ded'] ?? 'NO';

        $user = $_SESSION['CURRENT_USER'];
        $date = date('Y-m-d');

        // Check if exists
        $sqlCheck = "SELECT * FROM s_cheque_extend WHERE refno = ?";
        $stmtCheck = $conn->prepare($sqlCheck);
        $stmtCheck->execute([$refno]);

        if ($stmtCheck->rowCount() > 0) {
            // Update
            $sql = "UPDATE s_cheque_extend SET 
                ch_no=?, ch_date=?, ch_exdate=?, ch_amount=?, icode=?, cus_name=?, sal_ex=?, ins=?, user=?, sdate=? 
                WHERE refno=?";
            $stmt = $conn->prepare($sql);
            $stmt->execute([$chk_no, $chk_date, $extend_date, $amount, $cuscode, $cusname, $salesrep, $deduct, $user, $date, $refno]);
            $msg = "Updated Successfully";
        } else {
            // Insert
            $sql = "INSERT INTO s_cheque_extend 
                (refno, ch_no, ch_date, ch_exdate, ch_amount, icode, cus_name, sal_ex, ins, user, sdate, approved, acc_approved) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'PENDING', 'PENDING')";
            $stmt = $conn->prepare($sql);
            $stmt->execute([$refno, $chk_no, $chk_date, $extend_date, $amount, $cuscode, $cusname, $salesrep, $deduct, $user, $date]);
            $msg = "Saved Successfully";
        }

        echo json_encode(['status' => 'success', 'message' => $msg]);

    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "approve") {
    $refno = $_GET['refno'];
    $user = $_SESSION['UserName']; // Or CURRENT_USER

    // Check Permission (optional, but good)
    // Assuming UI handles simplified permission check via visibility

    $sql = "UPDATE s_cheque_extend SET approved='YES', approved_by='$user' WHERE refno='$refno'";
    $conn->query($sql);
    echo json_encode(['status' => 'success', 'message' => 'Approved']);
    exit;
}

if ($command == "deny") {
    $refno = $_GET['refno'];
    $sql = "UPDATE s_cheque_extend SET approved='NO' WHERE refno='$refno'";
    $conn->query($sql);
    echo json_encode(['status' => 'success', 'message' => 'Denied']);
    exit;
}

if ($command == "acc_approve") {
    $refno = $_GET['refno'];
    $user = $_SESSION['UserName'];

    $sql = "UPDATE s_cheque_extend SET acc_approved='YES', acc_approved_by='$user' WHERE refno='$refno'";
    $conn->query($sql);
    echo json_encode(['status' => 'success', 'message' => 'Account Approved']);
    exit;
}

if ($command == "acc_no") {
    $refno = $_GET['refno'];
    $sql = "UPDATE s_cheque_extend SET acc_approved='NO' WHERE refno='$refno'";
    $conn->query($sql);
    echo json_encode(['status' => 'success', 'message' => 'Account Rejected']);
    exit;
}

if ($command == "get_cheque_details") {
    $refno = $_GET['refno'];
    $sql = "SELECT * FROM s_cheque_extend WHERE refno='$refno'";
    $res = $conn->query($sql);

    if ($row = $res->fetch(PDO::FETCH_ASSOC)) {
        echo json_encode(['status' => 'success', 'data' => $row]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Not Found']);
    }
    exit;
}
?>