<?php 
session_start();
require_once("connectioni.php");
date_default_timezone_set('Asia/Colombo');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GIN Cash Reciept</title>
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <!-- Scripts -->
    <script language="JavaScript" src="js/cash_1.js"></script>

    <!-- Popup Window Script -->
    <script language="javascript" type="text/javascript">
    var win=null;
    function NewWindow(mypage,myname,w,h,scroll,pos){
        if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
        if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
        else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
        settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
        win=window.open(mypage,myname,settings);
    }
    
    function close_form() {
        close();
    }
    </script>
    
    <!-- Initial Load Script -->
    <script type="text/javascript">
     // Polymorph legacy date picker calls to avoid errors
     function load_calader(tar){
        // No-op or native handling
     }
     
     // Note: Legacy code called new_inv() via menu click, standardizing to load on new if needed,
     // but usually users click "New". However, some legacy files had window.onload logic.
     // cash_reciept_details1.php had JsDatePick initialization.
    </script>

    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles */
        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c;
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }
        
        /* Box/Card Styling */
        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
        }
        .box.box-primary {
            border-top-color: #3c8dbc;
        }
        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
        }
        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
        }
        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }
        .control-label {
            font-weight: 600;
            text-align: left !important;
            padding-top: 7px;
        }
        
        /* Buttons */
        .btn {
            border-radius: 3px;
            box-shadow: none;
            border: 1px solid transparent;
        }

        /* Table Styling Overrides */
        .CSSTableGenerator table {
            width: 100%;
            border-collapse: collapse;
            background-color: #fff;
        }
        .CSSTableGenerator th {
            background-color: #3c8dbc;
            color: white;
            padding: 8px;
            text-align: left;
        }
        .CSSTableGenerator td {
            padding: 8px;
            border: 1px solid #f4f4f4;
        }
        
        /* Scrollable table containers */
        .table-scroll {
            overflow-y: auto;
            border: 1px solid #f4f4f4;
        }

        /* Legacy overrides */
        input[disabled], select[disabled] {
            cursor: not-allowed;
            background-color: #eee;
        }
    </style>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        
        <div class="page-title-box">
            GIN Cash Reciept
        </div>
        
        <div class="user-info">
             <span>Welcome, <span class="user-name"><?php echo $_SESSION['user_name']; ?></span> [<?php echo $_SESSION['company']; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

<div class="content-wrapper">
    <section class="content">

        <!-- Action Toolbar -->
        <div class="box box-solid">
            <div class="box-body">
                <a onclick="new_inv();" class="btn btn-app">
                    <i class="fa fa-plus"></i> New
                </a>
                <?php 
                // Permissions Logic
                $sql_per="select * from view_userpermission where username='".$_SESSION["UserName"]."' and docname='Gin Receipt' and grp='Data Capture' ";
                $result_per =mysqli_query($GLOBALS['dbinv'],$sql_per);
                if ($row_per = mysqli_fetch_array($result_per)) {
                    if($row_per['doc_feed']==1){
                        echo '<a onclick="save_crec();" class="btn btn-app"><i class="fa fa-save"></i> Save</a>';
                    }
                    if($row_per['doc_cancel']==1){
                        echo '<a onclick="delete_rec();" class="btn btn-app"><i class="fa fa-times"></i> Cancel</a>';
                    }
                    if($row_per['doc_print']==1){
                        echo '<a onclick="print_inv();" class="btn btn-app"><i class="fa fa-print"></i> Print</a>';
                    }
                    if($row_per['doc_feed']==1){
                        echo '<a onclick="utilization();" class="btn btn-app"><i class="fa fa-check-square-o"></i> Utilization</a>';
                    }
                }
                ?>
                <a onclick="close_form();" class="btn btn-app">
                    <i class="fa fa-close"></i> Close
                </a>
            </div>
        </div>

        <div class="row">
            <!-- Details -->
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Receipt Details</h3>
                    </div>
                    <div class="box-body">
                        <form role="form" name="form1" id="form1" class="form-horizontal">
                            
                             <!-- Hidden Fields -->
                            <input type="hidden" name="cmd_new" id="cmd_new" value="1" />
                            <input type="hidden" name="cmd_save" id="cmd_save" value="0"/>
                            <input type="hidden" name="cmd_cancel" id="cmd_cancel" value="0"/>
                            <input type="hidden" name="cmd_print" id="cmd_print" value="0"/>
                            <input type="hidden" name="cmd_utilization" id="cmd_utilization" value="0"/>    
                            <input type="hidden" name="hiddencount" id="hiddencount" />
                            
                            <!-- Row 1: Receipt No, Links, Sales Rep -->
                            <div class="form-group bg-info" style="padding: 10px 0; margin-bottom: 15px;">
                                <label class="col-sm-1 control-label">Receipt No</label>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="invno" id="invno" disabled onkeypress="keyset('searchcust',event);" onfocus="got_focus('invno');"  onblur="lost_focus('invno');">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="serach_rec_gin.php?stname=cash_rec_gin" onClick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-2 control-label">Marketing Executive</label>
                                <div class="col-sm-3">
                                     <select name="salesrep" id="salesrep" onkeypress="keyset('paytype',event);" onchange="custno('cash_rec_rep');" class="form-control input-sm">
                                      <?php
                                        $sql="select * from s_salrep where cancel='0' order by REPCODE";
                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                        while($row = mysqli_fetch_array($result)){
                                            echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            
                            <!-- Row 2: Customer -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Customer</label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="cuscode" id="cuscode" onblur="search_cust_ind();" onkeypress="keyset('salesrep',event);">
                                </div>
                                <div class="col-sm-4">
                                     <div class="input-group">
                                        <input type="text" class="form-control input-sm" id="cusname" name="cusname" disabled>
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="serach_customer.php?stname=cash_rec" onclick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-2 control-label">Cheque Collected</label>
                                <div class="col-sm-3">
                                     <select name="chqcollect" id="chqcollect" onkeypress="keyset('dte_dor',event);" onchange="setord();" class="form-control input-sm">
                                        <?php
                                        $sql="select * from s_salrep order by REPCODE";
                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                        while($row = mysqli_fetch_array($result)){
                                            echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                        }
                                        ?>
                                      </select>
                                </div>
                            </div>
                            
                            <!-- Row 3: Address, Entry Date, Cost Center -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Address</label>
                                <div class="col-sm-5">
                                    <input type="text" class="form-control input-sm" id="cus_address" name="cus_address" disabled>
                                </div>
                                <label class="col-sm-1 control-label">Entry Date</label>
                                <div class="col-sm-2">
                                    <input type="date" name="invdate" id="invdate" value="<?php echo date("Y-m-d"); ?>" disabled class="form-control input-sm">
                                </div>
                                <label class="col-sm-1 control-label">Cost Center</label>
                                <div class="col-sm-2">
                                     <select name="costcenter" id="costcenter"  class="form-control input-sm">
                                      <?php 
                                        for ($i=1; $i<51; $i++){
                                            echo "<option value=".$i.">".$i."</option>";
                                        }
                                     ?>
                                    </select>
                                </div>
                            </div>

                             <!-- Row 4: Payment Type, T/T Date, T/T No, CA Ref -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Payment Type</label>
                                <div class="col-sm-2">
                                    <select name="paytype" id="paytype"  class="form-control input-sm">
                                      <option selected="selected" value="Cash">Cash</option>
                                      <option value="Cheque">Cheque</option>
                                      <option value="J/Entry">J/Entry</option>
                                      <option value="Cash TT">Cash TT</option>
                                    </select>
                                </div>
                                
                                <label class="col-sm-1 control-label">T/T Date</label>
                                <div class="col-sm-2">
                                     <div id="tt">
                                      <input type="date" name="dt" id="dt" value="<?php echo date("Y-m-d"); ?>" class="form-control input-sm">
                                     </div>
                                </div>
                                
                                <label class="col-sm-1 control-label">T/T No</label>
                                <div class="col-sm-2">
                                     <a href="search_grn.php?stname=grn" onclick="NewWindow(this.href,'mywin','800','700','yes','center');return false" class="btn btn-default btn-xs btn-block">Search</a>
                                </div>
                                <div class="col-sm-3">
                                    <input type="text" class="form-control input-sm" name="ca_refno" id="ca_refno" onblur="search_cust_ind();" placeholder="CA Ref No">
                                </div>
                            </div>
                            
                            <hr>
                            
                            <!-- Tables Row -->
                            <div class="row">
                                <!-- Cheque Details -->
                                <div class="col-md-6">
                                    <div class="box box-warning">
                                        <div class="box-header with-border">
                                            <h3 class="box-title">Cheques Details</h3>
                                        </div>
                                        <div class="box-body">
                                            <table class="table table-condensed table-bordered">
                                                <tr>
                                                    <td><input type="text" name="chqno" id="chqno" class="form-control input-sm" placeholder="Cheque No" onkeypress="keyset('chqdate',event);"></td>
                                                    <td>
                                                        <?php
                                                        if ($_SESSION['company']=="THT"){
                                                            echo '<input type="date" class="form-control input-sm" id="chqdate" name="chqdate" onblur="chk_calader();"  onkeypress="keyset(\'bank\',event);" >';
                                                        } else {
                                                            echo '<input type="date" class="form-control input-sm" id="chqdate" name="chqdate" onkeypress="keyset(\'bank\',event);" >';
                                                        }
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <div class="input-group">
                                                            <input type="text" name="bank" id="bank" class="form-control input-sm" placeholder="Bank" onblur="get_bank();" onkeypress="keyset('chqamt',event);">
                                                            <span class="input-group-btn">
                                                                <a class="btn btn-default btn-sm" href="search_bank.php?stname=cash_rec" onclick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <input type="text" name="chqamt" id="chqamt" class="form-control input-sm text-right" placeholder="Amount" onblur="calc1();" onkeypress="keyset('additem_tmp',event);">
                                                    </td>
                                                    <td>
                                                        <button type="button" name="additem_tmp" id="additem_tmp" class="btn btn-primary btn-sm" onclick="addchq_cash_rec();"><i class="fa fa-plus"></i></button>
                                                    </td>
                                                </tr>
                                            </table>
                                            
                                            <div class="table-scroll" style="height: 170px;">
                                                 <div class="CSSTableGenerator" id="chq_table">
                                                      <!-- Cheque table loaded here -->
                                                      <table class="table table-bordered">
                                                            <tr>
                                                              <th width="10%">Cheque No</th>
                                                              <th width="10%">Cheque Date</th>
                                                              <th width="10%">Bank</th>
                                                              <th width="10%">Qty</th>
                                                              <th width="10%">Amount</th>
                                                            </tr>
                                                      </table>
                                                 </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Utilization Details -->
                                <div class="col-md-6">
                                    <div class="box box-success">
                                        <div class="box-header with-border">
                                            <h3 class="box-title">Utilization Details</h3>
                                        </div>
                                        <div class="box-body">
                                            <div class="CSSTableGenerator table-scroll" id="utilization" style="height: 235px;">
                                                <!-- Utilization content loaded via AJAX -->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Totals Row -->
                             <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="col-sm-3 control-label">Cheque Total</label>
                                        <div class="col-sm-3">
                                            <input type="text" name="chqtot" id="chqtot" class="form-control input-sm text-right" disabled>
                                        </div>
                                        <label class="col-sm-3 control-label">Cash Total</label>
                                        <div class="col-sm-3">
                                            <input type="text" name="cashtot" id="cashtot" class="form-control input-sm text-right">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6"></div>
                            </div>
                            
                            <!-- Invoice Details Section -->
                            <div class="row">
                                <div class="col-md-12">
                                    <fieldset>
                                        <legend>Invoice Details</legend>
                                        <div class="CSSTableGenerator" id="inv_details">
                                             <div class="CSSTableGenerator" id="itemdetails">
                                                <table class="table table-bordered">
                                                  <tr>
                                                    <th>Code</th>
                                                    <th>Description</th>
                                                    <th>Rate</th>
                                                    <th>Qty</th>
                                                    <th>Discount</th>
                                                    <th>Sub Total</th> 
                                                  </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                            
                            <br>
                            
                            <!-- Bottom Totals -->
                            <div class="row">
                                <div class="col-sm-6 pull-right">
                                     <div class="form-group">
                                        <label class="col-sm-4 control-label">Selected Invoice Amount</label>
                                        <div class="col-sm-8">
                                            <input type="text" name="txtpaytot" id="txtpaytot" class="form-control input-sm text-right" disabled>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-4 control-label">Over Payment</label>
                                        <div class="col-sm-8">
                                            <input type="text" name="txtoverpay" id="txtoverpay" class="form-control input-sm text-right" disabled>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        </form>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div><!-- /.col -->
        </div><!-- /.row -->

    </section>
</div>

<script>
    // Keyboard Shortcut for Logout (Ctrl+Q)
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
            event.preventDefault();
            window.location.href = 'logout.php';
        }
    });
</script>
</body>
</html>