<?php 
session_start();
require_once("connectioni.php");
date_default_timezone_set('Asia/Colombo');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Receipt</title>
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <!-- Scripts -->
    <script language="JavaScript" src="js/cash.js"></script>

    <!-- Popup Window Script -->
    <script language="javascript" type="text/javascript">
    var win=null;
    function NewWindow(mypage,myname,w,h,scroll,pos){
        if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
        if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
        else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
        settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
        win=window.open(mypage,myname,settings);
    }
    
    function NewWindow1(mypage,myname,w,h,scroll,pos){
        mypage=mypage+'&cus_id='+document.getElementById("cuscode").value;
        if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
        if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
        else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
        settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
        win=window.open(mypage,myname,settings);
    }

    function close_form() {
        close();
    }
    </script>
    
    <!-- Initial Load Script -->
    <script type="text/javascript">
     window.onload = function(){
        new_inv(); // Initialize
     };
    </script>

    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles */
        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c;
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }
        
        /* Box/Card Styling */
        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
        }
        .box.box-primary {
            border-top-color: #3c8dbc;
        }
        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
        }
        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
        }
        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }
        .control-label {
            font-weight: 600;
            text-align: left !important;
            padding-top: 7px;
        }
        
        /* Buttons */
        .btn {
            border-radius: 3px;
            box-shadow: none;
            border: 1px solid transparent;
        }

        /* Table Styling Overrides */
        #chq_table table, #utilization table, #inv_details table {
            width: 100%;
            margin-bottom: 20px;
            border: 1px solid #f4f4f4;
            border-collapse: collapse;
            font-size: 13px;
        }
        #chq_table table th, #chq_table table td,
        #utilization table th, #utilization table td,
        #inv_details table th, #inv_details table td {
            padding: 8px;
            line-height: 1.42857143;
            vertical-align: top;
            border: 1px solid #ddd;
        }
        #chq_table table tr:first-child td,
        #inv_details table tr:first-child td {
            background-color: #3c8dbc !important;
            color: white !important;
            font-weight: bold;
            border-bottom: 2px solid #3c8dbc;
        }
        
        /* Utility */
        .mt-10 { margin-top: 10px; }
        
        /* Legacy overrides */
        .hidden { display: none; }
        input[disabled], select[disabled], textarea[disabled] {
            cursor: not-allowed;
            background-color: #eee;
            opacity: 1;
        }
    </style>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        
        <div class="page-title-box">
            Payment Receipt
        </div>
        
        <div class="user-info">
             <span>Welcome, <span class="user-name"><?php echo $_SESSION['user_name']; ?></span> [<?php echo $_SESSION['company']; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

<div class="content-wrapper">
    <section class="content">

        <!-- Action Toolbar -->
        <div class="box box-solid">
            <div class="box-body">
                <a onclick="new_inv();" class="btn btn-app">
                    <i class="fa fa-plus"></i> New
                </a>
                
                <?php 
                $sql_per="select * from view_userpermission where username='".$_SESSION["UserName"]."' and docname='Cash Reciept' and doc_feed = '1'";
                $result_per =mysqli_query($GLOBALS['dbinv'],$sql_per);
                if ($row_per = mysqli_fetch_array($result_per)) {
                ?>  
                <a onclick="save_crec();" class="btn btn-app">
                    <i class="fa fa-save"></i> Save
                </a>
                <a onclick="delete_rec();" class="btn btn-app">
                    <i class="fa fa-trash"></i> Delete
                </a>
                <?php } ?>
                
                <a onclick="print_inv();" class="btn btn-app">
                    <i class="fa fa-print"></i> Print
                </a>
                <a onclick="utilization();" class="btn btn-app">
                    <i class="fa fa-list-alt"></i> Utilization
                </a>
                <a onclick="close_form();" class="btn btn-app">
                    <i class="fa fa-close"></i> Close
                </a>
            </div>
        </div>

        <div class="row">
            <!-- Details -->
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Receipt Details</h3>
                    </div>
                    <div class="box-body">
                        <form role="form" name="form1" id="form1" class="form-horizontal">
                            <!-- Hidden Fields -->
                            <input type="hidden" name="cmd_new" id="cmd_new" value="1" />
                            <input type="hidden" name="cmd_save" id="cmd_save" value="0"/>
                            <input type="hidden" name="cmd_cancel" id="cmd_cancel" value="0"/>
                            <input type="hidden" name="cmd_print" id="cmd_print" value="0"/>
                            <input type="hidden" name="cmd_utilization" id="cmd_utilization" value="0"/>
                            <input type="hidden" name="hiddencount" id="hiddencount" />
                            
                            <!-- Row 1: Receipt No, Sales Exec -->
                            <div class="form-group bg-info" style="padding: 10px 0; margin-bottom: 15px;">
                                <label class="col-sm-1 control-label">Receipt No</label>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="invno" id="invno" disabled onkeypress="keyset('searchcust',event);" onfocus="got_focus('invno');"  onblur="lost_focus('invno');">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="serach_rec.php?stname=cash_rec" onClick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-2 control-label">Sales Executive</label>
                                <div class="col-sm-3">
                                    <select name="salesrep" id="salesrep" onblur="custno('cash_rec_rep');" onkeypress="keyset('chqno',event);" class="form-control input-sm">
                                    <?php
                                    require_once("connectioni.php");
                                         $sql="select * from s_salrep where pactive='1' and  SCODE='" . $_SESSION['company'] . "' order by REPCODE";
                                         $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                         while($row = mysqli_fetch_array($result)){
                                         echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                         }
                                    ?>
                                    </select>
                                </div>
                            </div>

                            <!-- Row 2: Customer, Pay Collected By -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Customer</label>
                                <div class="col-sm-2">
                                     <input type="text" class="form-control input-sm" name="cuscode" id="cuscode" disabled  onblur="search_cust_ind();" onkeypress="keyset('salesrep',event);">
                                </div>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" id="cusname" disabled name="cusname">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="serach_customer.php?stname=cash_rec" onclick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-2 control-label">Pay Collected By</label>
                                <div class="col-sm-3">
                                    <select name="chqcollect" id="chqcollect" onkeypress="keyset('dte_dor',event);" onchange="setord();" class="form-control input-sm">
                                    <?php
                                         $sql="select * from s_salrep where pactive='1'   and  SCODE='" . $_SESSION['company'] . "'  order by REPCODE";
                                    $result = mysqli_query($GLOBALS['dbinv'], $sql);
                                    while ($row = mysqli_fetch_array($result)) {
                                        echo "<option value='" . $row["REPCODE"] . "'>" . $row["REPCODE"] . " " . $row["Name"] . "</option>";
                                    }
                                    ?>
                                    </select>
                                </div>
                            </div>
                            
                            <!-- Row 3: Address, Entry Date, Cash Type -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Address</label>
                                <div class="col-sm-5">
                                    <input type="text" class="form-control input-sm" id="cus_address" name="cus_address">
                                </div>
                                <label class="col-sm-1 control-label">Date</label>
                                <div class="col-sm-2">
                                     <input type="date" class="form-control input-sm" name="invdate" id="invdate" value="<?php echo date("Y-m-d"); ?>">
                                </div>
                                <label class="col-sm-1 control-label">Type</label>
                                <div class="col-sm-2">
                                    <select name="cashtype" id="cashtype" class="form-control input-sm">
                                        <option selected="selected" value=""></option>
                                        <option value="Funds Transfer">Funds Transfer</option>
                                        <option value="Credit Card Payment">Credit Card Payment</option> 
                                        <option value="Credit Card Commission">Credit Card Commission</option> 
                                        <option value="Stamp Duty">Stamp Duty</option> 
                                        <option value="Used Tyres">Used Tyres</option> 
                                    </select>
                                </div>
                            </div>
                            
                            <!-- Row 4: Payment Type, TT Date, Ref No, Cost Center -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Payment</label>
                                <div class="col-sm-2">
                                    <select name="paytype" id="paytype" class="form-control input-sm" onchange="chng_type();">
                                        <option value="Cash">Cash</option>
                                        <option selected="selected" value="Cheque">Cheque</option>
                                        <option value="J/Entry">J/Entry</option>
                                        <option value="Cash TT">Cash TT</option>
                                        <option value="Credit Card Commision">Credit Card Commision</option>
                                    </select>
                                </div>
                                <label class="col-sm-1 control-label">TT Date</label>
                                <div class="col-sm-2">
                                     <div id="tt">
                                        <input type="date" class="form-control input-sm" name="dt" id="dt" value="<?php echo date("Y-m-d"); ?>">
                                     </div>
                                </div>
                                <label class="col-sm-1 control-label"><a href="search_grn.php?stname=grn" onclick="NewWindow(this.href,'mywin','800','700','yes','center');return false">T/T Ref</a></label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="ca_refno" id="ca_refno">
                                </div>
                                <label class="col-sm-1 control-label">Cost C.</label>
                                <div class="col-sm-2">
                                    <select name="costcenter" id="costcenter" disabled class="form-control input-sm">
                                    <?php
                                    for ($i = 1; $i < 51; $i++) {
                                        echo "<option value=" . $i . ">" . $i . "</option>";
                                    }
                                    ?>
                                    </select>
                                </div>
                            </div>
                            
                            <!-- Row 5: Debit/Credit Accounts -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Debit Acc</label>
                                <div class="col-sm-5">
                                    <select name="accno" id="accno" onkeypress="keyset('dte_dor',event);" onchange="setord();" class="form-control input-sm">
                                    <?php
                                    include_once ("connectioni.php");
                                    $sql = "select * from a_lcodes where CAT='B' or CAT='C' or   C_CODE='120900' or C_CODE='120901' or C_CODE='120902'";
                                    $result = mysqli_query($GLOBALS['dbinv'], $sql);
                                    while ($row = mysqli_fetch_array($result)) {
                                        echo "<option value='" . $row["C_CODE"] . "'>" . $row["C_CODE"] . " " . $row["C_NAME"] . "</option>";
                                    }
                                    ?>
                                    </select>
                                    <input type="hidden" id="acc_name" name="acc_name" onkeypress="keyset('bank',event);" />
                                </div>
                                <label class="col-sm-1 control-label">Credit Acc</label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="accno2" id="accno2" value="120100" onkeypress="keyset('chqdate',event);">
                                </div>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" id="acc_name2" name="acc_name2" value="Trade Debtors" onkeypress="keyset('bank',event);">
                                </div>
                                <div class="col-sm-1">
                                    <a class="btn btn-default btn-sm" href="search_ledger_acc.php?stname=cash_rec2" onclick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                </div>
                            </div>
                            
                            <hr>
                            
                            <div class="row">
                                <!-- Cheque Details -->
                                <div class="col-md-6">
                                    <div class="box box-solid">
                                        <div class="box-header">
                                            <h3 class="box-title text-primary">Cheque Details</h3>
                                        </div>
                                        <div class="box-body">
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <label>Cheque No</label>
                                                    <input type="text" class="form-control input-sm" name="chqno" id="chqno" onkeypress="keyset('chqdate',event);"  onblur="chk_chqno();">
                                                </div>
                                                <div class="col-sm-3">
                                                    <label>Date</label>
                                                    <input type="date" class="form-control input-sm" name="chqdate" id="chqdate" onkeypress="keyset('bank',event);">
                                                </div>
                                                <div class="col-sm-3">
                                                    <label>Bank</label>
                                                    <div class="input-group">
                                                         <input type="text" class="form-control input-sm" name="bank" id="bank" onblur="get_bank();" onkeypress="keyset('chqamt',event);">
                                                         <span class="input-group-btn">
                                                            <a class="btn btn-default btn-sm" href="search_bank.php?stname=cash_rec" onclick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="col-sm-2">
                                                    <label>Amount</label>
                                                    <input type="text" class="form-control input-sm" name="chqamt" id="chqamt" onblur="calc1();" onkeypress="keyset('additem_tmp',event);">
                                                </div>
                                                <div class="col-sm-1">
                                                    <label>&nbsp;</label>
                                                    <button type="button" class="btn btn-primary btn-sm" name="additem_tmp" id="additem_tmp" onclick="addchq_cash_rec();">Add</button>
                                                </div>
                                            </div>
                                            <div class="row mt-10">
                                                <div class="col-sm-12">
                                                    <div id="itemdetails1111" style="height:170px; overflow-y: auto; border: 1px solid #ddd;">
                                                        <div id="chq_table"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Utilization Details -->
                                <div class="col-md-6">
                                    <div class="box box-solid">
                                        <div class="box-header">
                                            <h3 class="box-title text-primary">Utilization Details</h3>
                                        </div>
                                        <div class="box-body">
                                             <div id="utilization" style="height:235px; overflow-y: auto; border: 1px solid #ddd;"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Totals Section -->
                            <div class="row" style="margin-top: 10px;">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label">Cheque Tot</label>
                                        <div class="col-sm-4">
                                            <input type="text" class="form-control input-sm" name="chqtot" id="chqtot" disabled>
                                        </div>
                                        <label class="col-sm-2 control-label">Cash Tot</label>
                                        <div class="col-sm-4">
                                            <input type="number" class="form-control input-sm" name="cashtot" id="cashtot">
                                        </div>
                                    </div>
                                    <!-- Hidden / Extra Buttons -->
                                    <a href="search_unknown.php?stname=cash_rec2" onclick="NewWindow(this.href,'mywin','800','700','yes','center');return false">
                                        <input type="hidden" name="additem_tmp4" id="additem_tmp4" value="Select TT">
                                    </a>
                                    <input type="hidden" name="ledg_ref_no" id="ledg_ref_no" disabled>
                                    
                                    <div class="form-group">
                                         <div class="col-sm-12">
                                            <input type="button" class="btn btn-info btn-sm" name="idcopy2" id="idcopy2" value="View Dealer Signature(s)" onclick="NewWindow1('display_image.php?cou=image1','mywin','900','800','yes','center');return false" />
                                            <input type="button" class="btn btn-warning btn-sm" name="df" id="df" value="Select Up All" onclick="selectupall();" />
                                            
                                            <!-- Hidden buttons -->
                                            <input type="hidden" name="idcopy" id="idcopy" value="Dealer Signature2" onclick="NewWindow1('display_image.php?cou=image2','mywin','900','800','yes','center');return false" />
                                            <input type="hidden" name="idcopy3" id="idcopy3" value="BR Copy" onclick="NewWindow1('display_image.php?cou=image3','mywin','900','800','yes','center');return false" />
                                            <input type="hidden" name="idcopy4" id="idcopy4" value="Application Copy" onclick="NewWindow1('display_image.php?cou=image4','mywin','900','800','yes','center');return false" />
                                         </div>
                                    </div>
                                </div>
                            </div>

                            <hr>
                            <h4 class="box-title text-primary">Invoice Details</h4>
                            <div class="row">
                                <div class="col-md-12">
                                    <div id="inv_details" style="min-height: 150px; overflow-y: auto;">
                                        <!-- Invoice Grid -->
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Bottom Totals -->
                            <div class="row" style="margin-top: 20px;">
                                <div class="col-sm-4">
                                     <div style="color: red;font-size: 24px;" id="lblcancel"></div>
                                      <textarea name="remarks" id="remarks" class="form-control" rows="3" placeholder="Remarks"></textarea>
                                </div>
                                <div class="col-sm-8">
                                    <div class="form-group">
                                        <label class="col-sm-4 control-label">Total Outstanding</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control input-sm text-right" name="out" id="out" disabled>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-4 control-label">Selected Inv Amount</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control input-sm text-right" name="txtpaytot" id="txtpaytot" disabled>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-4 control-label">Over Payment</label>
                                        <div class="col-sm-8">
                                            <input type="text" class="form-control input-sm text-right" name="txtoverpay" id="txtoverpay" disabled>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </form>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div><!-- /.col -->
        </div><!-- /.row -->

    </section>
</div>

<script>
    // Keyboard Shortcut for Logout (Ctrl+Q)
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
            event.preventDefault();
            window.location.href = 'logout.php';
        }
    });
</script>
</body>
</html>