<?php 
session_start();
require_once("connectioni.php");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Arrival Note</title>
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <!-- Scripts -->
    <script type="text/javascript" src="js/get_cat_description.js"></script>
    <script type="text/javascript" src="js/datepickr.js"></script>
    
    <!-- Main Logic -->
    <script language="JavaScript" src="js/arn.js?v1"></script>

    <!-- Popup Window Script -->
    <script language="javascript" type="text/javascript">
    var win=null;
    function NewWindow(mypage,myname,w,h,scroll,pos){
        if(pos=="random"){LeftPosition=(screen.width)?Math.floor(Math.random()*(screen.width-w)):100;TopPosition=(screen.height)?Math.floor(Math.random()*((screen.height-h)-75)):100;}
        if(pos=="center"){LeftPosition=(screen.width)?(screen.width-w)/2:100;TopPosition=(screen.height)?(screen.height-h)/2:100;}
        else if((pos!="center" && pos!="random") || pos==null){LeftPosition=0;TopPosition=20}
        settings='width='+w+',height='+h+',top='+TopPosition+',left='+LeftPosition+',scrollbars='+scroll+',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
        win=window.open(mypage,myname,settings);
    }
    </script>
    
    <!-- Initial Load Script -->
    <script type="text/javascript">
     window.onload = function(){
        new_inv(); // Initialize
     };
    </script>

    <style>
        body {
            background-color: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); /* Light grey background for ERP feel */
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }
        
        /* Navbar Styles */
        .navbar-custom {
            background-color: #2c3e50; /* Primary Color */
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            text-decoration: none;
            padding: 0;
            height: auto;
            line-height: normal;
        }
        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .logout-btn {
            background-color: #e74c3c; /* Danger Color */
            color: white;
            border: none;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            transition: background 0.3s;
            text-decoration: none !important;
        }
        .logout-btn:hover {
            background-color: #c0392b;
            color: white;
        }
        .user-name {
            font-weight: bold;
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: 20px;
        }
        
        /* Box/Card Styling */
        .box {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            border-top: 3px solid #d2d6de;
            margin-bottom: 20px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            border-radius: 3px;
        }
        .box.box-primary {
            border-top-color: #3c8dbc;
        }
        .box-header {
            color: #444;
            display: block;
            padding: 10px;
            position: relative;
            border-bottom: 1px solid #f4f4f4;
        }
        .box-header .box-title {
            display: inline-block;
            font-size: 18px;
            margin: 0;
            line-height: 1;
        }
        .box-body {
            border-top-left-radius: 0;
            border-top-right-radius: 0;
            border-bottom-right-radius: 3px;
            border-bottom-left-radius: 3px;
            padding: 20px;
        }

        /* Form Controls */
        .form-control {
            border-radius: 0;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .form-control:focus {
            border-color: #3c8dbc;
            box-shadow: none;
        }
        .control-label {
            font-weight: 600;
            text-align: left !important;
            padding-top: 7px;
        }
        
        /* Buttons */
        .btn {
            border-radius: 3px;
            box-shadow: none;
            border: 1px solid transparent;
        }

        /* Table Styling Overrides (for AJAX Content) */
        #itemdetails table {
            width: 100%;
            margin-bottom: 20px;
            border: 1px solid #f4f4f4;
            border-collapse: collapse;
            font-size: 13px;
        }
        #itemdetails table th, #itemdetails table td {
            padding: 8px;
            line-height: 1.42857143;
            vertical-align: top;
            border: 1px solid #ddd;
        }
        #itemdetails table tr:first-child td {
            background-color: #3c8dbc !important;
            color: white !important;
            font-weight: bold;
            border-bottom: 2px solid #3c8dbc;
        }
        
        /* Utility */
        .mt-10 { margin-top: 10px; }
        .mb-10 { margin-bottom: 10px; }
        .p-0 { padding: 0 !important; }
        
        /* Legacy overrides */
        .hidden { display: none; }
        input[disabled], select[disabled], textarea[disabled] {
            cursor: not-allowed;
            background-color: #eee;
            opacity: 1;
        }
    </style>
</head>
<body class="hold-transition skin-blue layout-top-nav">

    <!-- Custom Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        
        <div class="page-title-box">
            Arrival Note
        </div>
        
        <div class="user-info">
            <span>Welcome, <span class="user-name"><?php echo $_SESSION['user_name']; ?></span> [<?php echo $_SESSION['company']; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

<div class="content-wrapper">
    <section class="content">

        <!-- Action Toolbar -->
        <div class="box box-solid">
            <div class="box-body">
                <a onclick="new_inv();" class="btn btn-app">
                    <i class="fa fa-plus"></i> New
                </a>
                <a onclick="save_inv();" class="btn btn-app">
                    <i class="fa fa-save"></i> Save
                </a>
                <a onclick="cancel_inv();" class="btn btn-app">
                    <i class="fa fa-trash"></i> Delete
                </a>
                <a onclick="print_inv();" class="btn btn-app">
                    <i class="fa fa-print"></i> Print
                </a>
                <a onclick="close_form();" class="btn btn-app">
                    <i class="fa fa-close"></i> Close
                </a>
            </div>
        </div>

        <div class="row">
            <!-- Details -->
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Arrival Note Details</h3>
                    </div>
                    <div class="box-body">
                        <form role="form" name="form1" id="form1" class="form-horizontal">
                            
                            <!-- Row 1: ARN No, Search, Entry Date -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">ARN No</label>
                                <div class="col-sm-2">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="invno" id="invno" disabled onkeypress="keyset('searchcust',event);">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="serach_arn.php" onClick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <label class="col-sm-1 control-label">Entry Date</label>
                                <div class="col-sm-2">
                                     <input type="date" class="form-control input-sm" name="invdate" id="invdate" value="<?php echo date("Y-m-d"); ?>">
                                </div>
                            </div>
                            
                            <!-- Row 2: LC/TT, PI, Dept -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">LC/TT No</label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="lc_no" id="lc_no">
                                </div>
                                <label class="col-sm-1 control-label">PI No</label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="pi_no" id="pi_no">
                                </div>
                                <label class="col-sm-1 control-label">Department</label>
                                <div class="col-sm-2">
                                    <select name="department" id="department" onkeypress="keyset('brand',event);" class="form-control input-sm">
                                      <?php
                                        if ($_SESSION["CURRENT_DEP"] != "") {
                                           $sql="select * from s_stomas where  act='1' and CODE='".$_SESSION["CURRENT_DEP"] ."' order by CODE";
                                        }else{
                                          $sql="select * from s_stomas where  act='1'  order by CODE";
                                        } 
                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                        while($row = mysqli_fetch_array($result)){
                                            if ($row["CODE"]=="1"){
                                                 echo "<option selected value='".$row["CODE"]."'>".$row["DESCRIPTION"]."</option>";
                                            }else {
                                                 echo "<option value='".$row["CODE"]."'>".$row["DESCRIPTION"]."</option>";
                                            }
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            
                            <!-- Row 3: PO Date, Brand, PO No -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">PO Date</label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="dte_dor" id="dte_dor" disabled>
                                </div>
                                <label class="col-sm-1 control-label">Brand</label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="brand" id="brand" disabled onkeypress="keyset('department',event);">
                                </div>
                                <label class="col-sm-1 control-label">PO No</label>
                                <div class="col-sm-2">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="orderno1" id="orderno1" disabled onkeypress="keyset('orderdate',event);">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="search_purord.php?stname=arn" onClick="NewWindow(this.href,'mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <!-- Row 4: Supplier, Country -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Supplier</label>
                                <div class="col-sm-2">
                                    <div class="input-group">
                                        <input type="text" class="form-control input-sm" name="supplier_code" id="supplier_code" disabled onblur="suppno_ind('arn');" onkeypress="keyset('purtype',event);">
                                        <span class="input-group-btn">
                                            <a class="btn btn-default btn-sm" href="" onClick="NewWindow('serach_supplier.php?stname=arn','mywin','800','700','yes','center');return false"><i class="fa fa-search"></i></a>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                     <input type="text" class="form-control input-sm" name="supplier_name" id="supplier_name" disabled onkeypress="keyset('department',event);">
                                </div>
                                <label class="col-sm-1 control-label">Country</label>
                                <div class="col-sm-2">
                                     <select class="form-control input-sm" id="country" name="country" disabled onkeypress="keyset('txtUNIT',event);"> 
                                      <?php $sql="select * from country "; 
                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                        while($row = mysqli_fetch_array($result)){
                                            echo "<option value='".$row["name"]."'>".$row["name"]." </option>";
                                        }?>
                                    </select>
                                </div>
                                <input type="hidden" name="count" id="count">
                            </div>

                            <!-- Row 5: CI No, BL No, Order By -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">CI No</label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="invno1" id="invno1" onkeypress="keyset('department',event);">
                                </div>
                                <label class="col-sm-1 control-label">BL No</label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="blno" id="blno" onkeypress="keyset('department',event);">
                                </div>
                                <label class="col-sm-1 control-label">Order By</label>
                                <div class="col-sm-2">
                                    <select name="salesrep" id="salesrep" disabled onkeypress="keyset('dte_dor',event);" class="form-control input-sm">
                                      <?php
                                        if ($_SESSION["MANAGER"]!="") { 			 						
                                            $sql="select * from s_salrep where pactive='1' and manager='".$_SESSION["MANAGER"]."'order by REPCODE"; 
                                        }else if ($_SESSION["CURRENT_REP"]=="") { 			 						
                                            $sql="select * from s_salrep where pactive='1' order by REPCODE";
                                        } else {
                                             $sql="select * from s_salrep where pactive='1' and repcode = '" . $_SESSION["CURRENT_REP"] ."' order by REPCODE";
                                        }
                                        $result =mysqli_query($GLOBALS['dbinv'],$sql) ; 
                                        while($row = mysqli_fetch_array($result)){
                                            echo "<option value='".$row["REPCODE"]."'>".$row["REPCODE"]." ".$row["Name"]."</option>";
                                        }
                                      ?>
                                    </select>
                                </div>
                            </div>
                            
                            <!-- Row 6: Container Size, Purchase Type, ARN Status, Buttons -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Container</label>
                                <div class="col-sm-2">
                                    <input type="text" class="form-control input-sm" name="contsize" id="contsize" onkeypress="keyset('creditlimit',event);">
                                </div>
                                <label class="col-sm-1 control-label">Type</label>
                                <div class="col-sm-2">
                                    <select name="purtype" id="purtype" onkeypress="keyset('vatgroup_0',event);" class="form-control input-sm" onchange="assignbrand();">
                                        <option value='Import'>Import</option>
                                        <option value='Local'>Local</option>
                                    </select>
                                </div>
                                <label class="col-sm-1 control-label">Status</label>
                                <div class="col-sm-2">
                                    <select name="arpend" id="arpend" class="form-control input-sm">
                                        <option value='0'>Received</option>	
                                        <option value='1'>Pending</option>
                                    </select>
                                </div>
                                <div class="col-sm-1">
                                    <button type="button" class="btn btn-warning btn-sm btn-block" onClick="update_arstat();">UPDATE STATUS</button>
                                </div>
                            </div>
                            
                            <!-- Hidden Cost Center (preserved) -->
                             <div class="form-group hidden">
                                <select name="costcenter" id="costcenter" onkeypress="keyset('vatgroup_0',event);" onchange="assignbrand();">
                                  <option> --Select-- </option>
                                  <?php for($i=1; $i<=10; $i++) { echo "<option value='$i'>$i</option>"; } ?>
                                </select>
                             </div>

                            <!-- Row 7: Remark, Invoice Date -->
                            <div class="form-group">
                                <label class="col-sm-1 control-label">Remark</label>
                                <div class="col-sm-5">
                                    <textarea name="textarea" id="textarea" class="form-control" rows="2"></textarea>
                                </div>
                                <label class="col-sm-1 control-label">Invoice Date</label>
                                <div class="col-sm-2">
                                    <input type="date" class="form-control input-sm" name="indate" id="indate" value="<?php echo date("Y-m-d"); ?>">
                                </div>
                            </div>

                            <hr>
                            <h4 class="box-title text-primary">Item Details</h4>
                            
                            <div class="row mt-10">
                                <div class="col-md-12">
                                    <div id="itemdetails">
                                        <!-- AJAX Content Loads Here -->
                                    </div>
                                </div>
                            </div>
                            
                            <hr>
                            
                            <!-- Totals Section -->
                            <div class="row">
                                <div class="col-md-6 pull-right">
                                    <div class="form-horizontal">
                                        <div class="form-group">
                                            <label class="col-sm-3 control-label">Sub ARN Value</label>
                                            <div class="col-sm-4">
                                                <input type="text" class="form-control input-sm" name="total_value" id="sub_val" disabled onblur="calc1();" style="text-align:right;" onkeypress="keyset('discount',event);">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-3 control-label">Total Discount</label>
                                            <div class="col-sm-4">
                                                <input type="text" class="form-control input-sm" name="total_dis" id="total_dis" disabled style="text-align:right;" onkeypress="keyset('discount',event);">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-3 control-label">Total ARN Value</label>
                                            <div class="col-sm-4">
                                                <input type="text" class="form-control input-sm" name="total_value" id="total_value" disabled onblur="calc1();" style="text-align:right;" onkeypress="keyset('discount',event);">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-3 control-label">Total Received Qty</label>
                                            <div class="col-sm-4">
                                                <input type="text" class="form-control input-sm" name="total_value" id="total_r_value" disabled style="text-align:right;" onkeypress="keyset('discount',event);">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-3 control-label">Total Order Qty</label>
                                            <div class="col-sm-4">
                                                <input type="text" class="form-control input-sm" name="total_o_value" id="total_o_value" disabled style="text-align:right;" onkeypress="keyset('discount',event);">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </form>
                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div><!-- /.col -->
        </div><!-- /.row -->

    </section>
</div>

<script>
    // Keyboard Shortcut for Logout (Ctrl+Q)
    document.addEventListener('keydown', function(event) {
        if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
            event.preventDefault();
            window.location.href = 'logout.php';
        }
    });
</script>
</body>
</html>
