<?php
session_start();
require_once("connection_sql.php");
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_POST['Command']) ? $_POST['Command'] : (isset($_GET['Command']) ? $_GET['Command'] : '');

if ($command == "get_list") {
    try {
        // Optimized SQL with LEFT JOIN to fetch invoice details (s_salma)
        // Selecting specific fields to avoid collisions and reduce data
        $sql = "SELECT 
                    d.*, 
                    s.CUS_NAME as inv_cus_name, 
                    s.SDATE as inv_date 
                FROM dag_item d
                LEFT JOIN s_salma s ON d.invno = s.REF_NO
                WHERE d.cancel='0'";

        // Filter by company if needed
        // if(isset($_SESSION['company']) && $_SESSION['company'] != "" && $_SESSION['company'] != "ALL") {
        //     $sql .= " AND d.company='".$_SESSION['company']."'";
        // }

        $sql .= " ORDER BY d.id DESC";

        $result = $conn->query($sql);

        $data = [];
        $i = 1;

        foreach ($result as $row) {

            // Status Logic
            $status_html = "";
            $status_bg = "";

            if ($row['reject'] == '0') {
                if ($row['flag'] == '0') {
                    $status_html = "ONHAND";
                    $status_bg = "yellow";
                } else if ($row['flag'] == '1') {
                    $status_html = "PRODUCTION";
                    $status_bg = "#acdcf3";
                } else if ($row['flag'] == '2') {
                    $status_html = "COMPLETE";
                    $status_bg = "#1ef51e";
                } else if ($row['flag'] == '3') {
                    $status_html = "OTHER COMPANY SEND";
                    $status_bg = "#1ef51e";
                } else if ($row['flag'] == '5') {
                    $status_html = "OTHER COMPANY RECEIVED";
                    $status_bg = "#1ef51e";
                } else if ($row['flag'] == '6') {
                    $status_html = "ONHAND TRANSFER PENDING";
                    $status_bg = "#1ef51e";
                } else if ($row['flag'] == '7') {
                    $status_html = "INVOICED";
                    $status_bg = "#eabf5d";
                }
            } else {
                if ($row['flag'] == '7') {
                    $status_html = "REJECTED & INVOICED";
                    $status_bg = "red";
                } else {
                    $status_html = "REJECTED";
                    $status_bg = "red";
                }
            }

            // Amount Logic based on flag
            $amount = $row['amount'];
            $repair = $row['repair'];
            $total = $row['total'];

            if ($row['flag'] == '7') {
                $amount = $row['amount1'];
                $repair = $row['repair1'];
                $total = $row['total1'];
            }

            $data[] = [
                'id' => $row['id'],
                'jobno' => $row['jobno'],
                'refno' => $row['refno'],
                'sdate' => $row['sdate'], // DAG Date
                'cusname' => $row['cusname'], // DAG Customer
                'marker' => $row['marker'],
                'size' => $row['size'],
                'belt' => $row['belt'],
                'serialno' => $row['serialno'],
                'adpayment' => $row['adpayment'],
                'amount' => $amount,
                'repair' => $repair,
                'total' => $total,
                'onhand_date' => $row['onhand_date'], // Send Date
                'pro_date' => $row['pro_date'], // Finish Date
                'invno' => $row['invno'],
                'inv_date' => $row['inv_date'],
                'inv_cus_name' => $row['inv_cus_name'],
                'warrenty' => $row['warrenty'],
                'remark' => $row['remark'],
                'status_html' => $status_html,
                'status_bg' => $status_bg
            ];
            $i++;
        }

        echo json_encode(['status' => 'success', 'data' => $data]);

    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

?>