<?php
session_start();
require_once("connectioni.php");
/*
if (!isset($_SESSION['company']) || $_SESSION['company'] == "") { 
    exit("Please Login");
}
if (!isset($_SESSION['CURRENT_USER']) || $_SESSION['CURRENT_USER'] == "") { 
    exit("Please Login");
}*/
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>All Items List</title>

    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <!-- DataTables -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.5.2/css/buttons.bootstrap.min.css">

    <style>
        body {
            background-color: #ecf0f5;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            font-size: 14px;
        }

        .navbar-custom {
            background-color: #2c3e50;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }

        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: white !important;
            padding: 0;
            line-height: normal;
        }

        .page-title-box {
            background: rgba(255, 255, 255, 0.1);
            padding: 8px 30px;
            border-radius: 5px;
            font-size: 18px;
            font-weight: 600;
            text-transform: uppercase;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .logout-btn {
            background-color: #e74c3c;
            color: white;
            padding: 6px 15px;
            border-radius: 4px;
            font-weight: 600;
            text-decoration: none !important;
        }

        .content-wrapper {
            padding: 20px;
        }

        .box {
            background: #fff;
            border-top: 3px solid #d2d6de;
            box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
            border-radius: 3px;
        }

        .box.box-primary {
            border-top-color: #3c8dbc;
        }

        .box-header {
            color: #444;
            border-bottom: 1px solid #f4f4f4;
            padding: 10px;
        }

        .box-body {
            padding: 20px;
        }
    </style>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

    <!-- DataTables Scripts -->
    <script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.2/js/buttons.print.min.js"></script>

    <script src="js/all_list.js"></script>
</head>

<body class="hold-transition skin-blue layout-top-nav">

    <!-- Navbar -->
    <div class="navbar-custom">
        <div class="navbar-brand">ERP SYSTEM MENU</div>
        <div class="page-title-box">ALL LIST</div>
        <div class="user-info">
            <span>Welcome, <span
                    class="user-name"><?php echo isset($_SESSION['CURRENT_USER']) ? $_SESSION['CURRENT_USER'] : 'User'; ?></span>
                [<?php echo isset($_SESSION['company']) ? $_SESSION['company'] : ''; ?>]</span>
            <a href="logout.php" class="logout-btn">Logout (Ctrl+Q)</a>
        </div>
    </div>

    <div class="content-wrapper">
        <section class="content">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">All Items List</h3>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table id="example" class="table table-striped table-bordered table-hover" style="width:100%">
                            <thead>
                                <tr class="danger">
                                    <th>#</th>
                                    <th>JOB NO</th>
                                    <th>DAG NO</th>
                                    <th>DAG DATE</th>
                                    <th>DAG CUSTOMER</th>
                                    <th>MAKE</th>
                                    <th>SIZE</th>
                                    <th>BELT</th>
                                    <th>SERIAL NO</th>
                                    <th>AD PAY</th>
                                    <th>AMOUNT</th>
                                    <th>REPAIR</th>
                                    <th>TOTAL</th>
                                    <th>SEND DATE</th>
                                    <th>FINISH</th>
                                    <th>INVOICE NO</th>
                                    <th>INVOICE DATE</th>
                                    <th>INVOICE CUSTOMER</th>
                                    <th>STATUS</th>
                                    <th>WARRENTY</th>
                                    <th>REMARK</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <script>
        document.addEventListener('keydown', function (event) {
            if (event.ctrlKey && (event.key === 'q' || event.key === 'Q')) {
                event.preventDefault();
                window.location.href = 'logout.php';
            }
        });
    </script>
</body>

</html>