<?php
session_start();
require_once("connection_sql.php");
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');

$command = isset($_POST['Command']) ? $_POST['Command'] : (isset($_GET['Command']) ? $_GET['Command'] : '');

if ($command == "get_initial_data") {
    $data = [];

    // Sales Reps
    $sql = "select * from s_salrep where pactive='1' order by REPCODE";
    $res = $conn->query($sql);
    $reps = [];
    foreach ($res as $row) {
        $reps[] = ['code' => $row['REPCODE'], 'name' => $row['Name']];
    }
    $data['reps'] = $reps;

    // Accounts
    // Legacy: select * from a_lcodes where (COMPANY... AND CAT='B') or (C_CODE='12501'...)
    $sql = "select * from a_lcodes where CAT='B' OR C_CODE IN ('12501','12503','12101') order by C_CODE";
    $res = $conn->query($sql);
    $accounts = [];
    foreach ($res as $row) {
        $accounts[] = ['code' => $row['C_CODE'], 'name' => $row['C_NAME']];
    }
    $data['accounts'] = $accounts;

    echo json_encode(['status' => 'success', 'data' => $data]);
    exit;
}

if ($command == "new_rec") {
    // Generate Receipt No
    // Legacy `invpara` or similar?
    // Using simple format like REC/YYMM/XXXX
    $refno = "REC/" . date("ym") . "/" . rand(1000, 9999);

    echo json_encode([
        'status' => 'success',
        'recno' => $refno,
        'date' => date('Y-m-d')
    ]);
    exit;
}

if ($command == "get_customer_invoices") {
    $cuscode = $_GET['cuscode'];

    // Fetch Outstanding Invoices
    // s_salma: REF_NO, GRAND_TOT, TOTPAY
    // Balance = GRAND_TOT - TOTPAY
    $sql = "SELECT * FROM s_salma WHERE C_CODE='$cuscode' AND (GRAND_TOT - TOTPAY) > 0 ORDER BY SDATE";
    $res = $conn->query($sql);

    $invoices = [];
    foreach ($res as $row) {
        $bal = $row['GRAND_TOT'] - $row['TOTPAY'];
        $invoices[] = [
            'refno' => $row['REF_NO'],
            'date' => $row['SDATE'],
            'amount' => $row['GRAND_TOT'],
            'balance' => $bal,
            'paid' => $row['TOTPAY']
        ];
    }

    // Get Customer Details
    $sqlCus = "SELECT * FROM vendor WHERE CODE='$cuscode'"; // or customer table? Usually s_salma joins...
    // Let's assume vendor table for now or we just return invoices.

    echo json_encode(['status' => 'success', 'invoices' => $invoices]);
    exit;
}

if ($command == "save_receipt") {
    try {
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $conn->beginTransaction();

        $input = json_decode(file_get_contents('php://input'), true);

        $recno = $input['recno'];
        $date = $input['date'];
        $cuscode = $input['cuscode'];
        $amount = $input['amount']; // Total Paid
        $payType = $input['payType']; // Cash, Cheque, etc.
        $cheques = $input['cheques'] ?? [];
        $allocations = $input['allocations'] ?? []; // Invoices settled

        // Insert Header (s_crec logic?)
        // Assuming table `s_crec` or similar based on legacy.
        // Or `s_invcheq` for cheques.
        // Legacy file `advance_payment.php` refers `s_crec` only in specific user permission check? No, I don't see insert query in file.
        // It was in `advace_payment_data.php` which was missing.
        // I'll create a generic `s_crec` structure.

        $sqlHead = "INSERT INTO s_crec (REF_NO, SDATE, C_CODE, AMOUNT, TYPE, FLAG, DEPARTMENT) VALUES (?, ?, ?, ?, ?, 'ADV', '0')";
        // FLAG='ADV' for Advance?
        $dept = $_SESSION['CURRENT_DEP'] ?? '0'; // Or input
        $conn->prepare($sqlHead)->execute([$recno, $date, $cuscode, $amount, $payType]);

        // Save Cheques
        $sqlCheq = "INSERT INTO s_invcheq (REF_NO, SDATE, C_CODE, CHNO, CH_DATE, BANK, CHEQUE_AMT) VALUES (?, ?, ?, ?, ?, ?, ?)";
        $stmtCheq = $conn->prepare($sqlCheq);

        foreach ($cheques as $chq) {
            $stmtCheq->execute([
                $recno,
                $date,
                $cuscode,
                $chq['no'],
                $chq['date'],
                $chq['bank'],
                $chq['amount']
            ]);
        }

        // Process Allocations (Settlement)
        // Update s_salma
        $sqlUpdate = "UPDATE s_salma SET TOTPAY = TOTPAY + ? WHERE REF_NO = ?";
        $stmtUpdate = $conn->prepare($sqlUpdate);

        foreach ($allocations as $alloc) {
            if ($alloc['settle_amount'] > 0) {
                $stmtUpdate->execute([$alloc['settle_amount'], $alloc['refno']]);
                // Log allocation if needed (s_sttr?)
            }
        }

        $conn->commit();
        echo json_encode(['status' => 'success', 'message' => 'Saved Successfully', 'recno' => $recno]);

    } catch (Exception $e) {
        $conn->rollBack();
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}

if ($command == "search_receipt") {
    $recno = $_GET['recno'];
    // Load Header
    $stmt = $conn->prepare("SELECT * FROM s_crec WHERE REF_NO = ?");
    $stmt->execute([$recno]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        // Load Cheques
        $stmtChq = $conn->prepare("SELECT * FROM s_invcheq WHERE REF_NO = ?");
        $stmtChq->execute([$recno]);
        $cheques = $stmtChq->fetchAll(PDO::FETCH_ASSOC);

        echo json_encode([
            'status' => 'success',
            'data' => [
                'header' => $row,
                'cheques' => $cheques
            ]
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Not Found']);
    }
    exit;
}

?>