<?php

if (isset($_POST["Import"])) {
    $filename = $_FILES["file"]["tmp_name"];
    if ($_FILES["file"]["size"] > 0) {
        // Check for CSV file type
        $file_type = pathinfo($_FILES["file"]["name"], PATHINFO_EXTENSION);
        if ($file_type !== 'csv') {
            echo "<script type=\"text/javascript\">
                alert(\"Please upload a CSV file.\");
                window.location = \"home.php?url=inv_barcode_up\"
            </script>";
            exit();
        }

        // Open file with correct encoding
        $file = fopen($filename, "r");
        
        // Database connection
        $conn = new mysqli("localhost", "coolmans_npeidcs", "e1E]0Mfua.0T4LL", "coolmans_npeidcs");
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        $i = 0;
        while (($emapData = fgetcsv($file, 10000, ",")) !== FALSE) {
            if ($i > 0) {
                if ($emapData[0] != "" && $emapData[1] != "" && $emapData[2] != "") {
                    // Prepare the query to avoid SQL injection
                    $stmt = $conn->prepare("DELETE FROM s_purtrn_barcode WHERE refno = ? AND stk_no = ? AND serino = ?");
                    $stmt->bind_param("sss", $emapData[0], $emapData[1], $emapData[2]);
                    $stmt->execute();

                    // Check if delete query was successful
                    if ($stmt->error) {
                        echo "<script type=\"text/javascript\">
                            alert(\"Error: " . $stmt->error . "\");
                            window.location = \"home.php?url=inv_barcode_up\"
                        </script>";
                        exit();
                    }

                    // Prepare insert query
                    $stmt = $conn->prepare("INSERT INTO s_purtrn_barcode(refno, stk_no, serino, seri_datetime) VALUES (?, ?, ?, ?)");
                    $stmt->bind_param("ssss", $emapData[0], $emapData[1], $emapData[2], date("Y-m-d H:i:s"));
                    $stmt->execute();

                    // Check if insert query was successful
                    if ($stmt->error) {
                        echo "<script type=\"text/javascript\">
                            alert(\"Error: " . $stmt->error . "\");
                            window.location = \"home.php?url=inv_barcode_up\"
                        </script>";
                        exit();
                    }
                }
            }
            $i++;
        }

        fclose($file);

        // Successful import message
        echo "<script type=\"text/javascript\">
            alert(\"CSV File has been successfully Imported.\");
            window.location = \"home.php?url=inv_barcode_up\"
        </script>";

        // Close connection
        $conn->close();
    } else {
        echo "<script type=\"text/javascript\">
            alert(\"File is empty or not uploaded.\");
            window.location = \"home.php?url=inv_barcode_up\"
        </script>";
    }
} else {
    echo "<script type=\"text/javascript\">
        window.location = \"home.php?url=inv_barcode_up\"
    </script>";
}
?>
