<?php
session_start();
require_once "connection_sql.php";

header('Content-Type: application/json');

$command = isset($_GET['Command']) ? $_GET['Command'] : '';

try {
    if ($command == 'list_all_purchases') {
        // List all purchases for popup selection
        $sql = "SELECT REFNO, SDATE, SUP_NAME, LCNO FROM s_purmas ORDER BY SDATE DESC LIMIT 100";
        $stmt = $conn->query($sql);
        $purchases = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode(['success' => true, 'purchases' => $purchases]);
        exit;
        
    } elseif ($command == 'find_purchase') {
        $refno = isset($_GET['refno']) ? trim($_GET['refno']) : '';
        
        if (empty($refno)) {
            echo json_encode(['success' => false, 'message' => 'Purchase No is required']);
            exit;
        }
        
        // Check if purchase exists in s_purmas
        $sql_purmas = "SELECT REFNO, SDATE, SUP_NAME FROM s_purmas WHERE REFNO = :refno";
        $stmt = $conn->prepare($sql_purmas);
        $stmt->bindParam(':refno', $refno);
        $stmt->execute();
        
        $purmas = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$purmas) {
            echo json_encode(['success' => false, 'message' => 'Purchase No not found']);
            exit;
        }
        
        // Fetch items from s_purtrn
        $sql_purtrn = "SELECT STK_NO, DESCRIPT, MANU_DATE1 as MANUFACTURE, EXP_DATE as EXDATE, REC_QTY as QTY 
                       FROM s_purtrn 
                       WHERE REFNO = :refno 
                       ORDER BY STK_NO";
        $stmt = $conn->prepare($sql_purtrn);
        $stmt->bindParam(':refno', $refno);
        $stmt->execute();
        
        $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'purchase' => $purmas,
            'items' => $items
        ]);
        
    } elseif ($command == 'save_barcodes') {
        $refno = isset($_POST['refno']) ? trim($_POST['refno']) : '';
        $barcodes = isset($_POST['barcodes']) ? json_decode($_POST['barcodes'], true) : [];
        
        if (empty($refno) || empty($barcodes)) {
            echo json_encode(['success' => false, 'message' => 'Invalid data']);
            exit;
        }
        
        $conn->beginTransaction();
        
        try {
            // Delete existing barcodes for this REFNO
            $sql_delete = "DELETE FROM s_purtrn_barcode WHERE refno = :refno";
            $stmt = $conn->prepare($sql_delete);
            $stmt->bindParam(':refno', $refno);
            $stmt->execute();
            
            // Insert new barcodes
            $sql_insert = "INSERT INTO s_purtrn_barcode (refno, stk_no, serino, seri_datetime) 
                          VALUES (:refno, :stk_no, :serino, :seri_datetime)";
            $stmt = $conn->prepare($sql_insert);
            
            foreach ($barcodes as $barcode) {
                $stmt->execute([
                    ':refno' => $refno,
                    ':stk_no' => $barcode['stkNo'],
                    ':serino' => $barcode['barcode'],
                    ':seri_datetime' => date('Y-m-d H:i:s')
                ]);
            }
            
            $conn->commit();
            echo json_encode(['success' => true, 'message' => 'Barcodes saved successfully']);
            
        } catch (Exception $e) {
            $conn->rollBack();
            echo json_encode(['success' => false, 'message' => 'Error saving: ' . $e->getMessage()]);
        }
        
    } elseif ($command == 'search_purchase') {
        $search = isset($_GET['search']) ? trim($_GET['search']) : '';
        
        if (empty($search)) {
            echo json_encode(['success' => false, 'message' => 'Search term required']);
            exit;
        }
        
        $sql = "SELECT REFNO, SDATE, SUP_NAME 
                FROM s_purmas 
                WHERE REFNO LIKE :search 
                   OR SUP_NAME LIKE :search 
                ORDER BY SDATE DESC 
                LIMIT 20";
        $stmt = $conn->prepare($sql);
        $searchTerm = '%' . $search . '%';
        $stmt->bindParam(':search', $searchTerm);
        $stmt->execute();
        
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode(['success' => true, 'results' => $results]);
        
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid command']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Server error: ' . $e->getMessage()]);
}
?>
