<?php
session_start();
require_once "connection_sql.php";
?>

<section class="content">
    <div class="box box-primary" id="barcode-center">
        <div class="box-header with-border">
            <h3 class="box-title">Barcode Center</h3>
            <div class="box-tools pull-right">
                <button type="button" class="btn btn-default btn-sm" id="bc-btn-new">
                    <i class="fa fa-file-o"></i> New
                </button>
            </div>
        </div>
        <div class="box-body">
            <!-- Purchase No Section -->
            <div class="row form-group">
                <div class="col-sm-6">
                    <label for="bc-purchase-no">Purchase No (REFNO)</label>
                    <div class="input-group">
                        <input type="text" class="form-control" id="bc-purchase-no" placeholder="Enter purchase no">
                        <span class="input-group-btn">
                            <button type="button" class="btn btn-info" id="bc-btn-find">
                                <i class="fa fa-search"></i> Find
                            </button>
                        </span>
                    </div>
                    
                </div>
                <div class="col-sm-6">
                    <label>Supplier</label>
                    <input type="text" class="form-control" id="bc-supplier" readonly>
                </div>
            </div>

            <!-- Master Items Frame -->
            <div class="panel panel-default bc-frame">
                <div class="panel-heading">
                    <strong>Frame1 - Master Items</strong>
                    
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered table-condensed table-hover" id="bc-master-table">
                        <thead>
                            <tr>
                                <th style="width:15%;">Stk No</th>
                                <th>Description</th>
                                <th style="width:12%;">Manufacture</th>
                                <th style="width:12%;">Exdate</th>
                                <th style="width:10%;" class="text-right">Qty</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td colspan="5" class="text-center text-muted">
                                    <em>Enter Purchase No and click Find to load items</em>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Barcode Capture Frame -->
            <div class="panel panel-default bc-frame">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-6">
                            <strong>Frame2 - Barcode Capture</strong>
                            
                        </div>
                        <div class="col-xs-6 text-right">
                            <button type="button" class="btn btn-success btn-xs" id="bc-btn-load" disabled>
                                <i class="fa fa-plus"></i> Load Barcode
                            </button>
                        </div>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="row form-group">
                        <div class="col-sm-6">
                            <label for="bc-barcode">Barcode</label>
                            <input type="text" class="form-control" id="bc-barcode" placeholder="Scan or type barcode" disabled>
                            <small class="text-muted">Press Enter to add</small>
                        </div>
                        <div class="col-sm-6">
                            <label for="bc-line">Link to Item (Stk No)</label>
                            <select class="form-control" id="bc-line" disabled>
                                <option value="">Select item...</option>
                            </select>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-bordered table-condensed" id="bc-capture-table">
                            <thead>
                                <tr>
                                    <th style="width:5%;">#</th>
                                    <th style="width:12%;">Stk No</th>
                                    <th>Description</th>
                                    <th style="width:12%;">Manufacture</th>
                                    <th style="width:12%;">Exdate</th>
                                    <th style="width:8%;" class="text-right">Qty</th>
                                    <th style="width:18%;">Barcode</th>
                                    <th style="width:6%;"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="8" class="text-center text-muted">
                                        <em>No barcodes captured yet</em>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="clearfix">
                <button type="button" class="btn btn-primary" id="bc-btn-save" disabled>
                    <i class="fa fa-save"></i> Save
                </button>
                <button type="button" class="btn btn-default" id="bc-btn-clear">
                    <i class="fa fa-refresh"></i> Clear
                </button>
                <span class="label label-info" id="bc-status" style="margin-left: 10px; padding: 8px; display: none;"></span>
            </div>
        </div>
    </div>
</section>

<!-- Purchase List Modal -->
<div class="modal fade" id="purchaseListModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-list"></i> Select Purchase Order</h4>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover table-condensed" id="purchase-list-table">
                        <thead>
                            <tr>
                                <th style="width:20%;">REFNO</th>
                                <th style="width:15%;">Date</th>
                                <th>Supplier</th>
                                <th style="width:15%;">LC No</th>
                                <th style="width:10%;"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td colspan="5" class="text-center">
                                    <i class="fa fa-spinner fa-spin"></i> Loading...
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<style>
#barcode-center .bc-frame {
    border: 2px solid #3c8dbc;
    margin-bottom: 20px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.12);
}

#barcode-center .bc-frame .panel-heading {
    background-color: #3c8dbc;
    color: white;
    padding: 10px 15px;
    font-weight: bold;
}

#barcode-center .panel-body {
    padding: 15px;
}

#barcode-center .table {
    margin-bottom: 0;
}

#barcode-center .table > thead > tr > th {
    background-color: #f4f4f4;
    font-weight: bold;
}

#barcode-center .table > tbody > tr > td {
    vertical-align: middle;
}

#barcode-center .btn {
    font-weight: 500;
}

#barcode-center #bc-status {
    font-size: 14px;
}

#barcode-center #bc-status.status-success {
    background-color: #00a65a;
}

#barcode-center #bc-status.status-error {
    background-color: #dd4b39;
}

#barcode-center #bc-status.status-info {
    background-color: #00c0ef;
}
</style>

<script src="js/barcode_center.js"></script>
