<?php
session_start();
include './connection_acc.php';
if ($_SESSION["CURRENT_USER"] == "") { 
    exit('Please Logging Again..');
} 
if ($_SESSION['company'] == "") { 
    exit('Please Logging Again..');
} 
?>

<!--Main Content-->

<!DOCTYPE html>
<html>
<head>
    <style>
        :root {
            --primary: #2c3e50;
            --accent: #2980b9;
            --bg-body: #ffffff;
            --text-color: #34495e; 
            --border-color: #dce4ec; 
            --white: #e2f7c1;
        }

        body {
            background-color: var(--bg-body) !important;
            font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
            color: var(--text-color);
        }

        .box.box-primary {
            border-top: 4px solid var(--primary); 
            box-shadow: 0 8px 20px rgba(0,0,0,0.1); 
            border-radius: 8px;
            background: var(--white);
            border-left: none;
            border-right: none;
            border-bottom: none;
            padding-bottom: 20px;
            margin-top: 20px;
        }

        .box-header {
            background-color: #e1e8d5;
            border-bottom: 1px solid #f0f0f0;
            padding: 12px 20px;
            border-radius: 8px 8px 0 0;
        }

        .box-title {
            color: var(--primary);
            font-weight: 700;
            font-size: 18px;
            letter-spacing: 0.5px;
        }

        .form-group {
            margin-bottom: 2px; 
        }

        .form-section-heading {
            color: var(--primary);
            font-size: 15px;
            font-weight: 700;
            text-transform: uppercase;
            border-bottom: 2px solid #eef2f5; 
            margin-bottom: 5px;
            padding-bottom: 5px;
            margin-top: 5px;
            letter-spacing: 0.8px;
            display: flex;
            align-items: center;
        }
        
        .form-section-heading i {
            margin-right: 8px;
            color: var(--accent);
            font-size: 14px;
        }

        .form-horizontal .control-label {
            text-align: left;
            font-weight: 600;
            color: #000000; 
            font-size: 13px;
            padding-top: 8px;
        }

        .form-control {
            border-radius: 4px;
            box-shadow: none;
            border: 1px solid var(--border-color);
            height: 34px;
            font-size: 13px;
            transition: all 0.2s ease;
            background-color: #fcfcfc;
        }

        .form-control:focus {
            border-color: var(--accent);
            box-shadow: 0 0 0 3px rgba(41, 128, 185, 0.1);
            background-color: #fff;
        }

        .form-control[disabled], .form-control[readonly] {
            background-color: #f4f6f8;
            color: #7f8c8d;
            border-color: #e5e9ec;
        }

        .btn {
            border-radius: 4px;
            font-weight: 600;
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            padding: 6px 15px;
            transition: all 0.2s;
        }

        .btn-default {
            background: #fff;
            border: 1px solid #dce4ec;
            color: #555;
        }
        .btn-default:hover {
            background: #f8f9fa;
            border-color: #b3c0d1;
        }

        .btn-success {
            background-color: #27ae60;
            border-color: #27ae60;
        }
        .btn-success:hover {
            background-color: #219150;
            box-shadow: 0 4px 10px rgba(39, 174, 96, 0.3);
            transform: translateY(-1px);
        }
        
        .input-group-btn .btn {
            height: 34px;
            border: 1px solid var(--border-color);
            border-left: none;
            background-color: #f8f9fa;
            padding: 6px 12px;
        }
        .input-group-btn .btn:hover {
            background-color: #e2e6ea;
        }

        .radio label, .checkbox label {
            padding-left: 25px;
            font-weight: 600;
            font-size: 13px;
            color: var(--text-color);
        }
        
        .btn-toolbar-custom {
            margin-bottom: 15px;
            border-bottom: 1px dashed #eef2f5;
            padding-bottom: 10px;
        }
        
        .text-right { text-align: right !important; }

    </style>
</head>
<body>

<section class="content">

    <div class="box box-primary">
        
        <div class="box-header">
            <h3 class="box-title"><i class="fa fa-briefcase"></i> &nbsp;Account Master</h3>
            <div class="box-tools pull-right">
                <span id="msg_box" style="font-weight:600; color:#e74c3c; margin-right: 15px;"></span>
            </div>
        </div>

        <form name="form1" role="form" class="form-horizontal">
            <div class="box-body">

                <div class="row">
                    <div class="col-md-12 btn-toolbar-custom">
                        <a onclick="new_inv();" class="btn btn-default">
                            <i class="fa fa-plus-circle" style="color:var(--accent);"></i>&nbsp; New
                        </a>
                        <a onclick="save_inv();" class="btn btn-success" style="margin-left:5px;">
                            <i class="fa fa-save"></i>&nbsp; Save Record
                        </a>
                    </div>
                </div>

                <div class="form-section-heading"><i class="fa fa-info-circle"></i> Basic Information</div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="col-sm-4 control-label" for="txt_entno">Account Code</label>
                            <div class="col-sm-8">
                                <div class="input-group">
                                    <input type="text" id="txt_entno" class="form-control" placeholder="Auto / Manual Code">
                                    <span class="input-group-btn">
                                        <button class="btn btn-default" type="button" onclick="NewWindow('search_ledg.php?stname=mas', 'mywin', '800', '700', 'yes', 'center'); return false;">
                                            <i class="fa fa-search"></i>
                                        </button>
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label class="col-sm-4 control-label" for="txt_accname">Account Name</label>
                            <div class="col-sm-8">
                                <input type="text" id="txt_accname" class="form-control" placeholder="Enter Account Name">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="col-sm-4 control-label" for="company">Company</label>
                            <div class="col-sm-8">
                                <select name="company" id="company" class="form-control">
                                    <option value="">Select Company</option>
                                    <?php
                                    $sql = "select * from a_dep_mas";
                                    foreach ($conn->query($sql) as $row) {
                                        // FIX: Check for both Uppercase and Lowercase keys to prevent empty list
                                        $comcode = isset($row["COMCODE"]) ? $row["COMCODE"] : $row["comcode"];
                                        $comp = isset($row["COMPANY"]) ? $row["COMPANY"] : $row["company"];
                                        
                                        // Only display if we found an ID
                                        if($comcode != "") {
                                            echo "<option value='" . $comcode . "'>" . $comcode . " - " . $comp . " </option>";
                                        }
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-4 control-label" for="txt_remarks">Remarks</label>
                            <div class="col-sm-8">
                                <input type="text" id="txt_remarks" class="form-control" placeholder="Internal notes...">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-section-heading"><i class="fa fa-tags"></i> Classification</div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="col-sm-4 control-label">Account Type</label>
                            <div class="col-sm-8">
                                <div class="radio">
                                    <label><input type="radio" name="optradio" id="manu" value="Manufacturing"> Mfg </label>
                                    <label style="margin-left:15px;"><input type="radio" name="optradio" id="pnl" value="PNL"> PNL </label>
                                    <label style="margin-left:15px;"><input type="radio" name="optradio" id="bal" value="Balance"> BS </label>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-4 control-label">Report Group 1</label>
                            <div class="col-sm-8">
                                <select name="ptype1" id="ptype1" class="form-control">
                                    <option value="">Select Group 1</option>
                                    <?php
                                    $sql = "select P_SUBGRO1 from a_lcodes GROUP BY P_SUBGRO1";
                                    foreach ($conn->query($sql) as $row) {
                                        $grp1 = isset($row["P_SUBGRO1"]) ? $row["P_SUBGRO1"] : $row["p_subgro1"];
                                        echo "<option value='" . $grp1 . "'>" . $grp1 . "</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="col-sm-4 control-label">Category</label>
                            <div class="col-sm-4">
                                <select name="acType" id="acType" class="form-control">
                                    <option value="Assets">Assets</option>
                                    <option value="Liabilities">Liabilities</option>
                                    <option value="Equity">Equity</option>
                                    <option value="Revenue">Revenue</option>
                                    <option value="Expenses">Expenses</option>
                                </select>
                            </div>
                            <div class="col-sm-4">
                                <select name="acType1" id="acType1" class="form-control">
                                    <option value="">Sub Cat</option>
                                    <?php
                                    $sql = "select * from a_lcodes_cat";
                                    foreach ($conn->query($sql) as $row) {
                                        $cat = isset($row["cat"]) ? $row["cat"] : $row["CAT"];
                                        echo "<option value='" . $cat . "'>" . $cat . "</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-4 control-label">Report Group 2</label>
                            <div class="col-sm-8">
                                <select name="ptype2" id="ptype2" class="form-control">
                                    <option value="">Select Group 2</option>
                                    <?php
                                    $sql = "select P_SUBGRO2 from a_lcodes GROUP BY P_SUBGRO2";
                                    foreach ($conn->query($sql) as $row) {
                                        $grp2 = isset($row["P_SUBGRO2"]) ? $row["P_SUBGRO2"] : $row["p_subgro2"];
                                        echo "<option value='" . $grp2 . "'>" . $grp2 . "</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                     <div class="col-md-6">
                         <div class="form-group">
                            <label class="col-sm-4 control-label">Bank Account</label>
                            <div class="col-sm-8">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" id="bank"> <span style="color:#e67e22; font-weight:600;">Mark as Payment / Bank Account</span>
                                    </label>
                                </div>
                            </div>
                        </div>
                     </div>
                </div>

                <div class="form-section-heading"><i class="fa fa-money"></i> Financial Details</div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="col-sm-4 control-label" for="txt_Opening">Opening Bal.</label>
                            <div class="col-sm-8">
                                <input type="text" id="txt_Opening" class="form-control text-right" placeholder="0.00">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-4 control-label" for="currency">Currency / Rate</label>
                            <div class="col-sm-4">
                                <select id="currency" onchange='loadcur();' class="form-control">
                                    <option value='LKR'>LKR</option>
                                    <?php
                                    $sql = "select * from a_mastercurrancy where currancy <> 'LKR'";
                                    foreach ($conn->query($sql) as $row) {
                                        $curr = isset($row["currancy"]) ? $row["currancy"] : $row["CURRANCY"];
                                        echo "<option value='" . $curr . "'>" . $curr . "</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="col-sm-4">
                                <input type="text" value="1" id="txt_rate" disabled="disabled" class="form-control text-right">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                         <div class="form-group">
                            <label class="col-sm-4 control-label" for="dtpOpenDate">As At Date</label>
                            <div class="col-sm-8">
                                <input type="date" id="dtpOpenDate" value="<?php echo date('Y-m-d'); ?>" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-4 control-label" for="txt_gl_code">Parent Acc.</label>
                            <div class="col-sm-8">
                                <div class="input-group">
                                    <input type="text" id="txt_gl_code" class="form-control" placeholder="Code">
                                    <span class="input-group-btn" style="width:0px;"></span>
                                    <input type="text" id="txt_gl_name" class="form-control" placeholder="Parent Description" readonly style="width: 50%;">
                                    <span class="input-group-btn">
                                        <button class="btn btn-default" id="cmd_glcode" onClick="NewWindow('search_ledg.php', 'mywin', '800', '700', 'yes', 'center'); return false">
                                            <i class="fa fa-search"></i>
                                        </button>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-section-heading"><i class="fa fa-calendar"></i> Budgeting </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="col-sm-6 control-label">January</label>
                            <div class="col-sm-6">
                                <input type="text" id="txt_jan" class="form-control text-right" placeholder="0.00">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-6 control-label">February</label>
                            <div class="col-sm-6">
                                <input type="text" id="txt_feb" class="form-control text-right" placeholder="0.00">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-6 control-label">March</label>
                            <div class="col-sm-6">
                                <input type="text" id="txt_mar" class="form-control text-right" placeholder="0.00">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-6 control-label">April</label>
                            <div class="col-sm-6">
                                <input type="text" id="txt_apr" class="form-control text-right" placeholder="0.00">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="col-sm-6 control-label">May</label>
                            <div class="col-sm-6">
                                <input type="text" id="txt_may" class="form-control text-right" placeholder="0.00">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-6 control-label">June</label>
                            <div class="col-sm-6">
                                <input type="text" id="txt_jun" class="form-control text-right" placeholder="0.00">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-6 control-label">July</label>
                            <div class="col-sm-6">
                                <input type="text" id="txt_jul" class="form-control text-right" placeholder="0.00">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-6 control-label">August</label>
                            <div class="col-sm-6">
                                <input type="text" id="txt_aug" class="form-control text-right" placeholder="0.00">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="col-sm-6 control-label">September</label>
                            <div class="col-sm-6">
                                <input type="text" id="txt_sep" class="form-control text-right" placeholder="0.00">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-6 control-label">October</label>
                            <div class="col-sm-6">
                                <input type="text" id="txt_oct" class="form-control text-right" placeholder="0.00">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-6 control-label">November</label>
                            <div class="col-sm-6">
                                <input type="text" id="txt_nov" class="form-control text-right" placeholder="0.00">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-6 control-label">December</label>
                            <div class="col-sm-6">
                                <input type="text" id="txt_dec" class="form-control text-right" placeholder="0.00">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-section-heading"><i class="fa fa-paperclip"></i> Attachments</div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Upload File</label>
                            <div class="col-sm-4">
                                <input id="file-3" name="file-3" multiple="true" type="file" class="form-control">
                            </div>
                            <div class="col-sm-2">
                                <a class="btn btn-primary btn-block" onclick="uploadfile('led');" style="background:var(--primary); border:none;">
                                    <i class="fa fa-cloud-upload"></i> Upload
                                </a>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-sm-10 col-sm-offset-2" id="filebox">
                                </div>
                        </div>
                    </div>
                </div>

            </div>
        </form>
    </div>

</section>

<script src="js/account_master.js">

</script>
<script>
    new_inv();
</script>
<?php
include 'login.php';
?>